/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class AvailableVariablesAction
extends PlanActionSupport {
    private static final Logger log = Logger.getLogger(AvailableVariablesAction.class);
    private List<VariableDefinition> inheritedNotOverridden;
    private List<VariableDefinition> variables;
    private List<VariableDefinition> projectVariables;
    private List<VariableDefinition> globalVariables;
    private VariableDefinitionManager variableDefinitionManager;

    public List<VariableDefinition> getVariables() {
        if (this.variables == null) {
            ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
            this.variables = job != null ? this.variableDefinitionManager.getPlanVariables((PlanIdentifier)job.getParent()) : this.variableDefinitionManager.getPlanVariables((PlanIdentifier)this.getImmutablePlan());
            this.variables = new ArrayList<VariableDefinition>(PasswordMaskingUtils.maskPasswordValues(this.variables, VariableDefinitionImpl::new));
        }
        return this.variables;
    }

    private ImmutablePlan getImmutableChain() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job != null) {
            return job.getParent();
        }
        return this.getImmutablePlan();
    }

    private List<VariableDefinition> getInheritedNotOverridden() {
        if (this.inheritedNotOverridden == null) {
            this.inheritedNotOverridden = new ArrayList<VariableDefinition>(PasswordMaskingUtils.maskPasswordValues((Collection)this.variableDefinitionManager.getInheritedNotOverriddenVariables((PlanIdentifier)this.getImmutableChain()), VariableDefinitionImpl::clone));
        }
        return this.inheritedNotOverridden;
    }

    public List<VariableDefinition> getGlobalVariables() {
        if (this.globalVariables == null) {
            this.globalVariables = this.getInheritedNotOverridden().stream().filter(VariableType.GLOBAL.isSameType()).collect(Collectors.toList());
        }
        return this.globalVariables;
    }

    public List<VariableDefinition> getProjectVariables() {
        if (this.projectVariables == null) {
            this.projectVariables = this.getInheritedNotOverridden().stream().filter(VariableType.PROJECT.isSameType()).collect(Collectors.toList());
        }
        return this.projectVariables;
    }

    public void setVariableDefinitionManager(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }
}

