/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class StrutsPrepareFilter
extends org.apache.struts2.dispatcher.filter.StrutsPrepareFilter {
    private static final Logger log = Logger.getLogger(StrutsPrepareFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            this.handleRequest((HttpServletRequest)req, res, chain);
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest httpServletRequest, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.shouldPrepare(httpServletRequest)) {
            super.doFilter((ServletRequest)httpServletRequest, res, this.updateHttpRequestAndContinue(chain));
        } else {
            try {
                chain.doFilter((ServletRequest)httpServletRequest, res);
            }
            finally {
                this.prepare.cleanupRequest(httpServletRequest);
            }
        }
    }

    private FilterChain updateHttpRequestAndContinue(final FilterChain chain) {
        return new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                try {
                    RequestCacheThreadLocal.update((HttpServletRequest)((HttpServletRequest)request));
                }
                catch (IllegalArgumentException e) {
                    ((HttpServletResponse)response).sendError(400, e.getMessage());
                    return;
                }
                chain.doFilter(request, response);
            }
        };
    }

    private boolean shouldPrepare(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        return servletPath.endsWith(".action") || servletPath.startsWith("/plugins/servlet");
    }
}

