/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.bamboo.filter.UrlRewriteFilter;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObject;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationContext {
    private static final Logger log = Logger.getLogger(NavigationContext.class);
    public static final String PLAN_KEY_PLACEHOLDER = "\\$\\{planKey\\}";
    public static final String BUILD_NUMBER_PLACEHOLDER = "\\$\\{buildNumber\\}";
    private static final String DEFAULT_JOB_URL = "/browse/";
    private static final String DEFAULT_CHAIN_URL = "/browse/";
    private static final String CHAIN_CONFIG_NAME_SPACE = "/chain/admin";
    private static final String JOB_CONFIG_NAME_SPACE = "/build/admin/edit";
    private static final String DEFAULT_CHAIN_CONFIG_URL = "/chain/admin/config/editChainDetails.action?planKey=";
    private static final String DEFAULT_JOB_CONFIG_URL = "/build/admin/edit/editBuildDetails.action?buildKey=";
    @NotNull
    private final DecoratedNavObject currentPlan;
    @Nullable
    private final DecoratedNavObject parentPlan;
    @NotNull
    private final String currentUrl;
    @Nullable
    private final String jobUrlPattern;
    @Nullable
    private final String chainUrlPattern;

    public NavigationContext(@NotNull String currentUrl, @NotNull DecoratedNavObject navObject, @Nullable String jobUrl, @Nullable String chainUrl) {
        this.currentUrl = this.cleanUrl(currentUrl);
        this.currentPlan = navObject;
        this.parentPlan = navObject.getParent() != null ? navObject.getParent() : navObject;
        this.jobUrlPattern = StringUtils.isNotBlank((CharSequence)jobUrl) ? this.cleanUrl(jobUrl) : (PlanType.JOB == navObject.getPlanType() ? currentUrl : null);
        this.chainUrlPattern = StringUtils.isNotBlank((CharSequence)chainUrl) ? this.cleanUrl(chainUrl) : (PlanType.CHAIN == navObject.getPlanType() ? currentUrl : null);
    }

    public DecoratedNavObject getNavObject() {
        return this.parentPlan;
    }

    public DecoratedNavObject getCurrentObject() {
        return this.currentPlan;
    }

    public String getCurrentKey() {
        return this.currentPlan.getKey();
    }

    public String getJobUrl(DecoratedNavObject job) {
        String newUrl = null;
        if (StringUtils.isNotBlank((CharSequence)this.jobUrlPattern)) {
            newUrl = job.replaceKey(this.jobUrlPattern, this.currentPlan);
        } else {
            String possibleUrl = job.replaceKey(this.currentUrl, this.currentPlan);
            if (NavigationContext.isValid(possibleUrl, false)) {
                newUrl = possibleUrl;
            }
        }
        if (newUrl != null) {
            newUrl = newUrl.replaceAll("&saved=true", "").replaceAll("\\?saved=true", "?");
            return newUrl;
        }
        return this.getDefaultJobUrl(job.getKey());
    }

    public String getChainUrl(DecoratedNavObject chain) {
        String newUrl = null;
        if (StringUtils.isNotBlank((CharSequence)this.chainUrlPattern)) {
            newUrl = chain.replaceKey(this.chainUrlPattern, this.currentPlan);
        } else {
            String possibleUrl = chain.replaceKey(this.currentUrl, this.currentPlan);
            if (NavigationContext.isValid(possibleUrl, true)) {
                newUrl = possibleUrl;
            }
        }
        if (newUrl != null) {
            return newUrl;
        }
        return this.getDefaultChainUrl(chain.getKey());
    }

    @Nullable
    public String getCurrentUrl() {
        return this.getCurrentObject().replaceKey(this.currentUrl, this.currentPlan);
    }

    private static boolean isValid(@Nullable String possibleUrl, boolean chain) {
        if (possibleUrl == null) {
            return false;
        }
        Map<Pattern, String> mappings = chain ? UrlRewriteFilter.getChainUrlMappings() : UrlRewriteFilter.getBuildableUrlMappings();
        for (Pattern regex : mappings.keySet()) {
            if (!regex.matcher(possibleUrl).matches()) continue;
            return true;
        }
        return false;
    }

    protected String getDefaultChainUrl(String key) {
        if (this.currentUrl.contains(CHAIN_CONFIG_NAME_SPACE) || this.currentUrl.contains(JOB_CONFIG_NAME_SPACE)) {
            return DEFAULT_CHAIN_CONFIG_URL + key;
        }
        return "/browse/" + key;
    }

    protected String getDefaultJobUrl(String key) {
        if (this.currentUrl.contains(CHAIN_CONFIG_NAME_SPACE) || this.currentUrl.contains(JOB_CONFIG_NAME_SPACE)) {
            return DEFAULT_JOB_CONFIG_URL + key;
        }
        return "/browse/" + key;
    }

    private String cleanUrl(String url) {
        url = UrlUtils.prependSlashIfDoesntExist((String)url);
        url = UrlUtils.stripTailingSlashes((String)url);
        return url;
    }
}

