/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.compatability.Content2HTMLPage;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.webapp.decorator.BaseWebAppDecorator;
import com.opensymphony.sitemesh.webapp.decorator.NoDecorator;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts2.sitemesh.TemplatePageFilter;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.ScopesHashModel;
import org.jetbrains.annotations.NotNull;

public class FreemarkerRequestDispatcherPageFilter
extends TemplatePageFilter {
    private static final Logger LOG = Logger.getLogger(FreemarkerRequestDispatcherPageFilter.class);
    public static final String HEADER_X_HISTORY_XHR = "X-History-XHR";
    public static final String HEADER_NO_DECORATE = "X-No-Decorate";
    private static final String HEADER_X_PAGE_TITLE = "X-Page-Title";
    public static final String BAMBOO_SUCCESS_RETURN_MODE = "bamboo.successReturnMode";
    public static final String BAMBOO_SUCCESS_RETURN_MODE_JSON = "json";
    public static final String BAMBOO_SUCCESS_RETURN_MODE_JSON_AS_HTML = "json-as-html";
    private FilterConfig filterConfig;
    private static FreemarkerManager freemarkerManager;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
    }

    protected DecoratorSelector initDecoratorSelector(SiteMeshWebAppContext webAppContext) {
        Factory factory = Factory.getInstance((Config)new Config(this.filterConfig));
        factory.refresh();
        return new BambooDecoratorSelector(factory.getDecoratorMapper());
    }

    protected void applyDecorator(Page page, com.opensymphony.module.sitemesh.Decorator decorator, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, ActionContext ctx) throws ServletException, IOException {
        this.wireIfNeeded(ctx.getContainer(), ctx.getActionInvocation());
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("FreemarkerRequestDispatcherPageFilter#applyDecorator %s", decorator.getName()));
                if (page instanceof HTMLPage) {
                    HTMLPage htmlPage = (HTMLPage)page;
                    LOG.trace((Object)String.format("Head:\n%s", htmlPage.getHead()));
                }
                LOG.trace((Object)String.format("Body:\n%s", page.getBody()));
            }
            com.opensymphony.module.sitemesh.Decorator decoratorToUse = this.selectDecorator(page, decorator, req, res, ctx);
            Configuration config = freemarkerManager.getConfiguration(servletContext);
            Template template = config.getTemplate(decoratorToUse.getPage(), this.getLocale(ctx.getActionInvocation(), config));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("FreemarkerRequestDispatcherPageFilter#applyDecorator template:\n%s", template.toString()));
            }
            ScopesHashModel model = freemarkerManager.buildTemplateModel(ctx.getValueStack(), null, servletContext, req, res, config.getObjectWrapper());
            model.put("page", (Object)page);
            if (page instanceof HTMLPage) {
                HTMLPage htmlPage = (HTMLPage)page;
                model.put("head", (Object)htmlPage.getHead());
            }
            model.put("decorator", (Object)decoratorToUse);
            model.put("title", (Object)page.getTitle());
            model.put("body", (Object)page.getBody());
            model.put("page.properties", (Object)new SimpleHash(page.getProperties()));
            if (LOG.isTraceEnabled()) {
                StringWriter writer = new StringWriter();
                template.process((Object)model, (Writer)writer);
                LOG.trace((Object)String.format("FreemarkerRequestDispatcherPageFilter#applyDecorator rendered template:\n%s", writer.toString()));
                res.getWriter().append(writer.toString());
            } else {
                template.process((Object)model, (Writer)res.getWriter());
            }
        }
        catch (FileNotFoundException e) {
            LOG.trace((Object)"File not found exception ", (Throwable)e);
            this.tryRequestDispatcher(req, page, decorator, servletContext, res, e);
        }
        catch (Exception e) {
            String msg = "Error applying decorator: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    private void wireIfNeeded(Container container, ActionInvocation invocation) {
        boolean dummyAction = invocation.getClass().getName().equals("org.apache.struts2.sitemesh.TemplatePageFilter$DummyActionInvocation");
        if (dummyAction) {
            container.inject(invocation.getAction());
        }
    }

    @NotNull
    private com.opensymphony.module.sitemesh.Decorator selectDecorator(Page page, com.opensymphony.module.sitemesh.Decorator decorator, HttpServletRequest req, HttpServletResponse res, ActionContext ctx) throws Exception {
        boolean isHistoryXhr = Boolean.parseBoolean(req.getHeader(HEADER_X_HISTORY_XHR));
        boolean hasNoDecorateHeader = Boolean.parseBoolean(req.getHeader(HEADER_NO_DECORATE));
        if (!(isHistoryXhr || hasNoDecorateHeader || BAMBOO_SUCCESS_RETURN_MODE_JSON_AS_HTML.equals(req.getParameter(BAMBOO_SUCCESS_RETURN_MODE)))) {
            return decorator;
        }
        Factory factory = Factory.getInstance((Config)new Config(this.filterConfig));
        if (isHistoryXhr) {
            res.setHeader(HEADER_X_PAGE_TITLE, page.getTitle());
        }
        return factory.getDecoratorMapper().getNamedDecorator(req, "rest");
    }

    protected Locale getLocale(ActionInvocation invocation, Configuration configuration) {
        if (invocation.getAction() instanceof LocaleProvider) {
            return ((LocaleProvider)invocation.getAction()).getLocale();
        }
        return configuration.getLocale();
    }

    private void tryRequestDispatcher(HttpServletRequest req, Page page, com.opensymphony.module.sitemesh.Decorator decorator, ServletContext servletContext, HttpServletResponse res, Exception e) throws ServletException, IOException {
        try {
            req.setAttribute("__sitemesh__page", (Object)page);
            if (decorator.getURIPath() != null && servletContext.getContext(decorator.getURIPath()) != null) {
                servletContext = servletContext.getContext(decorator.getURIPath());
            }
            RequestDispatcher dispatcher = servletContext.getRequestDispatcher(decorator.getPage());
            dispatcher.include((ServletRequest)req, (ServletResponse)res);
            req.removeAttribute("__sitemesh__page");
        }
        catch (RuntimeException e2) {
            if (com.opensymphony.module.sitemesh.util.Container.get() == 1) {
                e.printStackTrace();
            }
            throw e2;
        }
    }

    @Inject(required=false)
    public static void setFreemarkerManager(FreemarkerManager mgr) {
        freemarkerManager = mgr;
    }

    private final class BambooSitemeshDecorator
    extends BaseWebAppDecorator {
        private final com.opensymphony.module.sitemesh.Decorator decorator;

        private BambooSitemeshDecorator(com.opensymphony.module.sitemesh.Decorator decorator) {
            this.decorator = decorator;
        }

        protected void render(Content content, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, SiteMeshWebAppContext webAppContext) throws IOException, ServletException {
            Content2HTMLPage page = new Content2HTMLPage(content, request);
            request.setAttribute("__sitemesh__page", (Object)page);
            FreemarkerRequestDispatcherPageFilter.this.applyDecorator((Page)page, this.decorator, request, response);
            request.removeAttribute("__sitemesh__page");
        }
    }

    private final class BambooDecoratorSelector
    implements DecoratorSelector {
        private final DecoratorMapper decoratorMapper;

        private BambooDecoratorSelector(DecoratorMapper decoratorMapper) {
            this.decoratorMapper = decoratorMapper;
        }

        public Decorator selectDecorator(Content content, SiteMeshContext context) {
            SiteMeshWebAppContext webAppContext = (SiteMeshWebAppContext)context;
            HttpServletRequest request = webAppContext.getRequest();
            com.opensymphony.module.sitemesh.Decorator decorator = this.decoratorMapper.getDecorator(request, (Page)new Content2HTMLPage(content, request));
            if (decorator == null || decorator.getPage() == null) {
                return new NoDecorator();
            }
            return new BambooSitemeshDecorator(decorator);
        }
    }
}

