/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.bamboo.DarkFeatureService;
import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deployments.cache.LinkedDeploymentProjectCacheService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.ImmutableVcsBambooSpecsSource;
import com.atlassian.bamboo.plan.ImmutableVcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.PlanFavouriteService;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugin.PluggableFooter;
import com.atlassian.bamboo.plugin.PluggableTopNavigation;
import com.atlassian.bamboo.plugin.descriptor.FooterModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.TopNavigationModuleDescriptor;
import com.atlassian.bamboo.plugin.web.model.BambooWebLink;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.server.ServerStatusInfo;
import com.atlassian.bamboo.server.ServerStatusProvider;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.BareFreeMarkerContext;
import com.atlassian.bamboo.ww2.FreeMarkerContextHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import io.atlassian.fugue.Suppliers;
import java.io.File;
import java.nio.charset.Charset;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreemarkerContext
implements BareFreeMarkerContext {
    private static final Logger log = Logger.getLogger(FreemarkerContext.class);
    private static final Duration REASONABLE_RENDERING_TIME = Duration.ofMillis(500L);
    private static final String REQUEST_USER = FreemarkerContext.class.getCanonicalName() + "_user";
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BambooLicenseManager bambooLicenseManager;
    private final BambooPermissionManager bambooPermissionManager;
    private final BambooUserManager bambooUserManager;
    private final BootstrapManager bootstrapManager;
    private final CachedPlanManager cachedPlanManager;
    private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    private final CommentManager commentManager;
    private final DarkFeatureService darkFeatureService;
    private final DocumentationLinkProvider documentationLinkProvider;
    private final FeatureManager featureManager;
    private final GravatarService gravatarService;
    private final LinkedDeploymentProjectCacheService linkedDeploymentProjectCacheService;
    private final NotificationManager notificationManager;
    private final PlanFavouriteService planFavouriteService;
    private final PlanManager planManager;
    private final PluginAccessor pluginAccessor;
    private final ServerStatusProvider serverStatusProvider;
    private final StorageCappingService storageCappingService;
    private final VcsRepositoryViewerManager vcsRepositoryViewerManager;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final WebResourceIntegration webResourceIntegration;
    private final SystemInfo systemInfo;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final CustomVariableContext customVariableContext;
    private final Supplier<String> systemEncodingSupplier = Suppliers.memoize(() -> Charset.defaultCharset().name());

    @Inject
    public FreemarkerContext(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooLicenseManager bambooLicenseManager, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager, BootstrapManager bootstrapManager, CachedPlanManager cachedPlanManager, CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, CommentManager commentManager, DarkFeatureService darkFeatureService, DocumentationLinkProvider documentationLinkProvider, FeatureManager featureManager, GravatarService gravatarService, LinkedDeploymentProjectCacheService linkedDeploymentProjectCacheService, NotificationManager notificationManager, PlanFavouriteService planFavouriteService, PlanManager planManager, PluginAccessor pluginAccessor, ServerStatusProvider serverStatusProvider, StorageCappingService storageCappingService, VcsRepositoryViewerManager vcsRepositoryViewerManager, DynamicWebInterfaceManager webInterfaceManager, WebResourceIntegration webResourceIntegration, SystemInfo systemInfo, WebResourceUrlProvider webResourceUrlProvider, CustomVariableContext customVariableContext) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooLicenseManager = bambooLicenseManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
        this.bootstrapManager = bootstrapManager;
        this.cachedPlanManager = cachedPlanManager;
        this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
        this.commentManager = commentManager;
        this.darkFeatureService = darkFeatureService;
        this.documentationLinkProvider = documentationLinkProvider;
        this.featureManager = featureManager;
        this.gravatarService = gravatarService;
        this.linkedDeploymentProjectCacheService = linkedDeploymentProjectCacheService;
        this.notificationManager = notificationManager;
        this.planFavouriteService = planFavouriteService;
        this.planManager = planManager;
        this.pluginAccessor = pluginAccessor;
        this.serverStatusProvider = serverStatusProvider;
        this.storageCappingService = storageCappingService;
        this.vcsRepositoryViewerManager = vcsRepositoryViewerManager;
        this.webInterfaceManager = webInterfaceManager;
        this.webResourceIntegration = webResourceIntegration;
        this.systemInfo = systemInfo;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public String getInstanceName() {
        return this.getAdministrationConfiguration().getInstanceName();
    }

    @Nullable
    public String getLogoPath() {
        File logoImage = new File(this.systemInfo.getApplicationHome(), this.getAdministrationConfiguration().getLookAndFeelConfiguration().getLogoPath());
        if (!logoImage.exists()) {
            return null;
        }
        return this.webResourceIntegration.getBaseUrl() + this.getAdministrationConfiguration().getLookAndFeelConfiguration().getLogoResourceUrl();
    }

    @Nullable
    public String getFaviconPath() {
        String faviconPath = this.systemInfo.getApplicationHome() + this.getAdministrationConfiguration().getLookAndFeelConfiguration().getFaviconPath();
        File faviconImage = new File(faviconPath);
        if (!faviconImage.exists()) {
            return null;
        }
        return this.webResourceIntegration.getBaseUrl() + this.getAdministrationConfiguration().getLookAndFeelConfiguration().getFaviconResourceUrl();
    }

    @Nullable
    public User getUser(@Nullable HttpServletRequest request) {
        String userName;
        if (request == null) {
            return null;
        }
        com.google.common.base.Optional attribute = (com.google.common.base.Optional)request.getAttribute(REQUEST_USER);
        if (attribute != null) {
            return (User)attribute.orNull();
        }
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance(null);
        Principal principal = securityConfig.getAuthenticator().getUser(request);
        User user = null;
        if (principal != null && (userName = principal.getName()) != null) {
            user = this.bambooUserManager.getUser(userName);
        }
        request.setAttribute(REQUEST_USER, (Object)com.google.common.base.Optional.fromNullable(user));
        return user;
    }

    public boolean isEnableSignup() {
        return this.bambooPermissionManager.isEnableSignup();
    }

    public boolean isUserAutocompleteAllowed() {
        return this.bambooUserManager.isUserAutocompleteAllowed();
    }

    public boolean isOnDemandInstance() {
        return false;
    }

    public boolean isEc2ConfigurationWarningRequired() {
        return this.featureManager.isRequiredEc2Configuration();
    }

    public String sanitizeUrl(String url) {
        return com.atlassian.bamboo.utils.UrlUtils.isSafeUrl((String)(url = UrlUtils.sanitizeUri((String)url))) ? url : "#";
    }

    @Nullable
    public String getCurrentUrl(HttpServletRequest request) {
        if (request != null) {
            String queryString = request.getQueryString();
            return request.getServletPath() + (queryString == null ? "" : "?" + queryString);
        }
        return null;
    }

    public boolean hasBuilds() {
        return this.cachedPlanManager.getAnyPlan(ImmutableTopLevelPlan.class::isInstance).isPresent();
    }

    public int getRemainingJobsLimit() {
        int numberOfJobs;
        int allowedNumberOfPlans = this.bambooLicenseManager.getAllowedNumberOfPlans();
        if (allowedNumberOfPlans != -1 && (double)((float)(numberOfJobs = this.planManager.getPlanCount(Buildable.class)) / (float)allowedNumberOfPlans) >= 0.8) {
            return allowedNumberOfPlans - numberOfJobs;
        }
        return -1;
    }

    public boolean isFavourite(ImmutablePlan plan, HttpServletRequest request) {
        return this.planFavouriteService.isFavourite(plan, this.getUser(request));
    }

    @Nullable
    public String getGravatarUrl(@Nullable String userName, String size) {
        BambooUser bambooUser;
        if (StringUtils.isNotBlank((CharSequence)userName) && (bambooUser = this.bambooUserManager.getBambooUser(userName)) != null) {
            return this.gravatarService.getGravatarUrl(bambooUser.getEmail(), NumberUtils.stringToInt((String)size));
        }
        return this.gravatarService.getDefaultGravatarUrl(NumberUtils.stringToInt((String)size));
    }

    @Nullable
    public BambooUser getBambooUser(@Nullable String username) {
        return this.bambooUserManager.getBambooUser(username);
    }

    public boolean isAuthorBambooServer(@Nullable String userName) {
        AdministrationConfiguration configuration = this.getAdministrationConfiguration();
        RepositorySettings repositorySettings = configuration.getRepositorySettings();
        return repositorySettings.getAuthorName().equalsIgnoreCase(userName);
    }

    @Deprecated
    public List<WebItemModuleDescriptor> getWebItemsForSectionNoAction(String sectionName, HttpServletRequest request) {
        return this.webInterfaceManager.getDisplayableItems(sectionName, this.getWebFragmentsContextMapNoAction(request));
    }

    public List<WebItem> getDynamicWebItemsForSectionNoAction(String sectionName, HttpServletRequest request) {
        return ImmutableList.copyOf((Iterable)this.webInterfaceManager.getDisplayableWebItems(sectionName, this.getWebFragmentsContextMapNoAction(request)));
    }

    @NotNull
    public List<Map<String, Object>> getWebItems(String sectionName, final HttpServletRequest request) {
        final Map<String, Object> contextMap = this.getWebFragmentsContextMapNoAction(request);
        return Lists.transform(this.getWebItemsForSectionNoAction(sectionName, request), (Function)new Function<WebItemModuleDescriptor, Map<String, Object>>(){

            public Map<String, Object> apply(WebItemModuleDescriptor moduleDescriptor) {
                BambooWebLink link = (BambooWebLink)Narrow.to((Object)moduleDescriptor.getLink(), BambooWebLink.class);
                if (link != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("text", moduleDescriptor.getWebLabel().getDisplayableLabel(request, contextMap));
                    map.put("id", link.getRenderedId(contextMap));
                    map.put("accesskey", link.getAccessKey(contextMap));
                    map.put("href", link.getDisplayableUrl(request, contextMap));
                    return map;
                }
                throw new IllegalArgumentException("WebItem must be a BambooWebItemModuleDescriptor but is " + moduleDescriptor);
            }
        });
    }

    @Deprecated
    public List<WebSectionModuleDescriptor> getWebSectionsForLocationNoAction(String location, HttpServletRequest request) {
        return this.webInterfaceManager.getDisplayableSections(location, this.getWebFragmentsContextMapNoAction(request));
    }

    public List<WebSection> getDynamicWebSectionsForLocationNoAction(String location, HttpServletRequest request) {
        return ImmutableList.copyOf((Iterable)this.webInterfaceManager.getDisplayableWebSections(location, this.getWebFragmentsContextMapNoAction(request)));
    }

    public List<WebSectionDto> getWebSectionsWithItems(@NotNull String location, @NotNull HttpServletRequest request, @NotNull String pageCrumb) {
        List<WebSection> sections = this.getDynamicWebSectionsForLocationNoAction(location, request);
        ArrayList<WebSectionDto> sectionDtos = new ArrayList<WebSectionDto>();
        boolean activeItemFound = false;
        for (WebSection section : sections) {
            boolean sectionActive = false;
            List<WebItem> items = this.getDynamicWebItemsForSectionNoAction(location + '/' + section.getId(), request);
            ArrayList<WebItemDto> itemDtos = new ArrayList<WebItemDto>();
            for (WebItem item : items) {
                boolean itemActive = !activeItemFound && this.isCurrentWebItem(item, request, pageCrumb);
                activeItemFound = activeItemFound || itemActive;
                sectionActive = sectionActive || itemActive;
                itemDtos.add(new WebItemDto(item, itemActive));
            }
            sectionDtos.add(new WebSectionDto(section, sectionActive, itemDtos));
        }
        return sectionDtos;
    }

    @VisibleForTesting
    boolean isCurrentWebItem(@NotNull WebItem webItem, @NotNull HttpServletRequest request, @NotNull String pageCrumb) {
        return Optional.ofNullable(webItem.getId()).filter(StringUtils::isNotEmpty).map(id -> Objects.equals(id, pageCrumb)).filter(active -> active).orElseGet(() -> Optional.of(StringUtils.defaultString((String)webItem.getUrl())).filter(StringUtils::isNotEmpty).map(url -> StringUtils.endsWith((CharSequence)url, (CharSequence)request.getRequestURI()) || StringUtils.endsWith((CharSequence)url, (CharSequence)(request.getRequestURI() + "?" + request.getQueryString()))).orElse(false));
    }

    public String renderFreemarkerTemplateNoAction(String templateString, HttpServletRequest request) {
        return this.webInterfaceManager.getWebFragmentHelper().renderVelocityFragment(templateString, this.getWebFragmentsContextMapNoAction(request));
    }

    private boolean hasGlobalPermission(Permission permission) {
        return this.bambooPermissionManager.hasPermission(permission, (Object)GlobalApplicationSecureObject.INSTANCE, null);
    }

    public boolean hasGlobalPermission(String permission) {
        return this.hasGlobalPermission(BambooPermission.buildFromName((String)permission));
    }

    public boolean hasGlobalAdminPermission() {
        return this.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
    }

    public boolean hasRestrictedAdminPermission() {
        return this.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
    }

    public boolean hasProjectAdminPermission(@NotNull Project project) {
        return this.bambooPermissionManager.hasProjectPermission((Permission)BambooPermission.ADMINISTRATION, project);
    }

    public boolean canCreateProject() {
        return this.bambooPermissionManager.canCreateProject();
    }

    public boolean canCreatePlanInProject(@NotNull Project project) {
        return this.bambooPermissionManager.canCreatePlanInProject(project);
    }

    public boolean canCreatePlan() {
        return this.bambooPermissionManager.canCreatePlan();
    }

    public boolean canRunCustomBuild(PlanIdentifier plan) {
        return this.bambooPermissionManager.canRunCustomBuild(plan.getPlanKey());
    }

    public boolean hasAdminPermission() {
        return this.hasGlobalAdminPermission() || this.hasRestrictedAdminPermission();
    }

    public BambooLicenseManager getBambooLicenseManager() {
        return this.bambooLicenseManager;
    }

    @NotNull
    public ServerLifecycleState getServerLifecycleState() {
        return this.getServerStatusInfo().getServerLifecycleState();
    }

    @NotNull
    public ServerStatusInfo getServerStatusInfo() {
        return this.serverStatusProvider.getServerStatusInfo();
    }

    @Nullable
    public PluggableTopNavigation getPluggableTopNavigation() {
        List modules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(TopNavigationModuleDescriptor.class);
        if (modules.isEmpty()) {
            return null;
        }
        if (modules.size() > 1) {
            log.warn((Object)("Multiple top navigation plugins found, using the first one: " + modules));
        }
        return ((TopNavigationModuleDescriptor)modules.get(0)).getModule();
    }

    @Nullable
    public PluggableFooter getPluggableFooter() {
        List modules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(FooterModuleDescriptor.class);
        if (modules.isEmpty()) {
            return null;
        }
        if (modules.size() > 1) {
            log.warn((Object)("Multiple top navigation plugins found, using the first one: " + modules));
        }
        return ((FooterModuleDescriptor)modules.get(0)).getModule();
    }

    @Nullable
    public Boolean shouldShowActionTip(@NotNull String actionKey, @NotNull HttpServletRequest request) {
        User currentUser = this.getUser(request);
        if (currentUser == null) {
            return null;
        }
        PropertySet properties = this.bambooUserManager.getPropertySet(this.getUser(request));
        if (properties != null) {
            return !Boolean.parseBoolean(properties.getString(String.format("%s.%s", "bamboo.user.actions", actionKey)));
        }
        return true;
    }

    public Map<String, Object> getWebFragmentsContextMapNoAction(HttpServletRequest request) {
        Map map = request.getParameterMap();
        HashMap<String, Object> webFragmentsContextMap = new HashMap<String, Object>();
        webFragmentsContextMap.put("user", this.getUser(request));
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] strArray = (String[])value;
                webFragmentsContextMap.put((String)key, strArray[0]);
                continue;
            }
            webFragmentsContextMap.put((String)key, value);
        }
        webFragmentsContextMap.put("request", request);
        return webFragmentsContextMap;
    }

    public Collection<String> getWebPanelsForPlan(@NotNull String location, @NotNull String planKey) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("planKey", planKey);
        return this.getWebPanels(location, context);
    }

    public Collection<String> getWebPanelsForResultsSummary(@NotNull String location, @NotNull ResultsSummary resultsSummary) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("resultsSummary", resultsSummary);
        return this.getWebPanels(location, context);
    }

    public Collection<String> getWebPanels(@NotNull String location) {
        return this.getWebPanels(location, Collections.emptyMap());
    }

    public Collection<String> getWebPanels(@NotNull String location, @NotNull Map<String, Object> context) {
        HashMap<String, Object> localContext = new HashMap<String, Object>(context);
        BambooActionSupport action = this.getAction();
        if (action != null) {
            localContext.putAll(action.getWebPanelContext(location));
        }
        localContext.put("action", action);
        return this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, localContext).stream().map(descriptor -> this.renderWebPanel((WebPanelModuleDescriptor)descriptor, (Map<String, Object>)localContext)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderWebPanel(@NotNull WebPanelModuleDescriptor descriptor, @NotNull Map<String, Object> context) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            String string = ((WebPanel)descriptor.getModule()).getHtml(context);
            return string;
        }
        finally {
            Duration elapsed = Duration.ofMillis(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            if (log.isDebugEnabled() || Comparators.isGreater((Comparable)elapsed, (Comparable)REASONABLE_RENDERING_TIME)) {
                log.info((Object)("Web panel " + descriptor.getLocation() + " " + descriptor.getCompleteKey() + " was being rendered for " + stopwatch));
            }
        }
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public DarkFeatureService getDarkFeatureService() {
        return this.darkFeatureService;
    }

    public DocumentationLinkProvider getHelpLink() {
        return this.documentationLinkProvider;
    }

    public StorageCappingService getStorageCappingService() {
        return this.storageCappingService;
    }

    @Nullable
    private BambooActionSupport getAction() {
        ActionInvocation actionInvocation;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (actionInvocation = actionContext.getActionInvocation()) != null) {
            return (BambooActionSupport)Narrow.to((Object)actionInvocation.getAction(), BambooActionSupport.class);
        }
        return null;
    }

    @Nullable
    public String getRssLink(@NotNull ImmutablePlan plan) {
        ImmutableVcsBambooSpecsSource specsSource = this.getVcsBambooSpecsSource(plan);
        return this.getRssLink(specsSource);
    }

    @Nullable
    public String getRssRepositoryId(@NotNull ImmutablePlan plan) {
        return this.getRssRepositoryId(this.getVcsBambooSpecsSource(plan));
    }

    @Nullable
    public String getRssLink(@NotNull DeploymentProject project) {
        return this.getRssLink(project.getVcsBambooSpecsSource());
    }

    @Nullable
    public String getRssRepositoryId(@NotNull DeploymentProject project) {
        return this.getRssRepositoryId(project.getVcsBambooSpecsSource());
    }

    public boolean isRssManagedPlan(@Nullable ImmutablePlan plan) {
        return plan != null && this.getVcsBambooSpecsSource(plan) != null;
    }

    @NotNull
    public String getSystemEncoding() {
        return this.systemEncodingSupplier.get();
    }

    @Nullable
    private String getRssRepositoryId(@Nullable ImmutableVcsBambooSpecsSource specsSource) {
        if (specsSource == null) {
            return null;
        }
        ImmutableVcsLocationBambooSpecsState specsState = specsSource.getVcsLocationBambooSpecsState();
        VcsRepositoryData vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(specsState.getVcsLocationId());
        if (vcsRepositoryData == null) {
            return null;
        }
        boolean canViewRepository = this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)vcsRepositoryData, null);
        if (!canViewRepository) {
            return null;
        }
        return String.valueOf(vcsRepositoryData.getRootVcsRepositoryId());
    }

    private String getRssLink(@Nullable ImmutableVcsBambooSpecsSource specsSource) {
        ImmutableVcsLocationBambooSpecsState specsState;
        VcsRepositoryData vcsRepositoryData;
        if (specsSource != null && (vcsRepositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData((specsState = specsSource.getVcsLocationBambooSpecsState()).getVcsLocationId())) != null) {
            VcsRepositoryViewer vcsRepositoryViewer = this.vcsRepositoryViewerManager.getViewerForRepository(vcsRepositoryData);
            return (String)this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext(), () -> {
                if (vcsRepositoryViewer != null) {
                    CommitFileImpl commitFile = new CommitFileImpl(specsState.getRevision(), specsSource.isYamlConfiguration() ? (String)specsSource.getSourceLocation().get() : BambooSpecsHandler.BAMBOO_SPECS_DIRECTORY, specsState.getRevision());
                    return vcsRepositoryViewer.getWebRepositoryUrlForFileRevision((CommitFile)commitFile, vcsRepositoryData);
                }
                return null;
            });
        }
        return null;
    }

    public boolean isRepositoryDashboardOn() {
        return SystemProperty.GLOBAL_REPOSITORY_DASHBOARD.getTypedValue();
    }

    @Nullable
    private ImmutableVcsBambooSpecsSource getVcsBambooSpecsSource(@NotNull ImmutablePlan plan) {
        ImmutableChain chain;
        ImmutableChain immutableChain = chain = plan instanceof ImmutableJob ? ((ImmutableJob)plan).getParent() : (ImmutableChain)plan;
        if (chain.hasMaster()) {
            chain = chain.getMaster();
        }
        return chain == null ? null : chain.getVcsBambooSpecsSource();
    }

    private AdministrationConfiguration getAdministrationConfiguration() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration();
    }

    public BootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    @Override
    @Nullable
    public String getXsrfToken() {
        return FreeMarkerContextHelper.getXsrfToken();
    }

    @Override
    public boolean isXsrfTokenNeeded(@Nullable String formActionDestination) {
        return FreeMarkerContextHelper.isXsrfTokenNeeded(formActionDestination);
    }

    public boolean hasLinkedDeployments(@Nullable PlanKey planKey) {
        if (planKey == null) {
            return false;
        }
        List relatedDeployments = this.linkedDeploymentProjectCacheService.getRelatedDeployments(planKey);
        return !relatedDeployments.isEmpty();
    }

    public boolean isFunctionalTest() {
        return BuildUtils.isFunctionalTest();
    }

    public boolean hasComments(@NotNull BambooIdProvider entity) {
        return this.commentManager.getEntityCommentCountNoTx(entity.getId()) > 0;
    }

    public boolean isShowAdminContactDetailsToAnonymousUsers() {
        return this.getAdministrationConfiguration().isShowAdminContactDetailsToAnonymousUsers();
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public boolean isBambooSpecsFailure(@Nullable ImmutableResultsSummary buildResult) {
        return buildResult != null && ResultSummaryHelper.isBambooSpecFailure((ImmutableResultsSummary)buildResult);
    }

    public boolean isBambooSpecsSuccess(@Nullable ImmutableResultsSummary buildResult) {
        return buildResult != null && ResultSummaryHelper.isBambooSpecSuccess((ImmutableResultsSummary)buildResult);
    }

    public boolean isBambooSpecsResult(@Nullable ImmutableResultsSummary buildResult) {
        return buildResult != null && ResultSummaryHelper.isBambooSpecResult((ImmutableResultsSummary)buildResult);
    }

    public boolean isAwaitingSpecsExecution(@Nullable ImmutablePlan plan) {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)plan, ImmutableJob.class);
        if (job != null) {
            return this.isAwaitingSpecsExecution((ImmutablePlan)job.getParent());
        }
        ImmutableChainBranch immutableChainBranch = (ImmutableChainBranch)Narrow.downTo((Object)plan, ImmutableChainBranch.class);
        return immutableChainBranch != null && immutableChainBranch.getBuildDefinition().getBranchSpecificConfiguration().isAwaitingSpecsExecution();
    }

    public static class WebItemDto {
        private final WebItem webItem;
        private final boolean active;

        public WebItemDto(WebItem webItem, boolean active) {
            this.webItem = webItem;
            this.active = active;
        }

        public WebItem getWebItem() {
            return this.webItem;
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static class WebSectionDto {
        private final WebSection webSection;
        private final boolean active;
        private final List<WebItemDto> items;

        public WebSectionDto(WebSection webSection, boolean active, List<WebItemDto> items) {
            this.webSection = webSection;
            this.active = active;
            this.items = items;
        }

        public WebSection getWebSection() {
            return this.webSection;
        }

        public boolean isActive() {
            return this.active;
        }

        public List<WebItemDto> getItems() {
            return this.items;
        }
    }
}

