/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.util.UrlUtils;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FreeMarkerContextHelper {
    private FreeMarkerContextHelper() {
    }

    @Nullable
    public static String getXsrfToken() {
        return XsrfTokenUtils.getXsrfToken(RequestCacheThreadLocal.getNonNullRequest());
    }

    public static boolean isXsrfTokenNeeded(@Nullable String formActionDestination) {
        if (StringUtils.isBlank((CharSequence)formActionDestination)) {
            return false;
        }
        assert (formActionDestination != null);
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        String requestUrl = request.getRequestURL().toString();
        URL fullActionUrl = UrlUtils.createUrl((String)requestUrl, (String)formActionDestination);
        return UrlUtils.isSameOrigin((URL)UrlUtils.createUrl((String)requestUrl), (URL)fullActionUrl);
    }
}

