/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooFreemarkerManagerSoyHelpers {
    private static final Logger log = Logger.getLogger(BambooFreemarkerManagerSoyHelpers.class);

    private BambooFreemarkerManagerSoyHelpers() {
    }

    public static class SoyHelper {
        private final Supplier<SoyTemplateRenderer> soyTemplateRenderer;
        private CacheLoader<SoyRendererParams, String> templateRenderer = new CacheLoader<SoyRendererParams, String>(){

            public String load(SoyRendererParams params) throws Exception {
                return this.renderNoCache(params.moduleKey, params.templateName, params.data);
            }
        };
        private final LoadingCache<SoyRendererParams, String> soyTemplateResultCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build(this.templateRenderer);

        public SoyHelper(Supplier<SoyTemplateRenderer> soyTemplateRenderer) {
            this.soyTemplateRenderer = soyTemplateRenderer;
        }

        public String render(String templateName, Map<String, Object> data) throws SoyException {
            return this.render("bamboo.web.resources:server-soy-templates", templateName, data);
        }

        public String render(String moduleKey, String templateName, Map<String, Object> data) throws SoyException {
            try {
                if (this.isCacheable(moduleKey, templateName)) {
                    return (String)this.soyTemplateResultCache.getUnchecked((Object)new SoyRendererParams(moduleKey, templateName, data));
                }
                return this.renderNoCache(moduleKey, templateName, data);
            }
            catch (Throwable e) {
                log.error((Object)("Error while rendering soy template: " + templateName), e);
                return ExceptionUtils.getStackTrace((Throwable)e);
            }
        }

        private String renderNoCache(String moduleKey, String templateName, Map<String, Object> data) throws SoyException {
            return this.soyTemplateRenderer.get().render(moduleKey, templateName, data);
        }

        private boolean isCacheable(@NotNull String moduleKey, @NotNull String templateName) {
            return moduleKey.equals("bamboo.web.resources:server-soy-templates") && templateName.equals("widget.icons.icon");
        }
    }

    static final class SoyRendererParams {
        public final String moduleKey;
        public final String templateName;
        public final Map<String, Object> data;

        public SoyRendererParams(String moduleKey, String templateName, Map<String, Object> data) {
            this.moduleKey = moduleKey;
            this.templateName = templateName;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoyRendererParams)) {
                return false;
            }
            SoyRendererParams that = (SoyRendererParams)o;
            if (!this.templateName.equals(that.templateName)) {
                return false;
            }
            if (!this.data.equals(that.data)) {
                return false;
            }
            return this.moduleKey.equals(that.moduleKey);
        }

        public int hashCode() {
            int result = this.moduleKey.hashCode();
            result = 31 * result + this.templateName.hashCode();
            result = 31 * result + this.data.hashCode();
            return result;
        }
    }
}

