/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.BambooRepositoryUtils;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.ww2.BambooFreemarkerManagerSoyHelpers;
import com.atlassian.bamboo.ww2.DebugWithoutThrowingExceptionHandler;
import com.atlassian.core.util.DateUtils;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import freemarker.cache.CacheStorage;
import freemarker.cache.ConcurrentStrongCacheStorage;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BambooFreemarkerManagerHelpers {
    private static final Logger log = Logger.getLogger(BambooFreemarkerManagerHelpers.class);

    private BambooFreemarkerManagerHelpers() {
    }

    static void convertStrutsToWebWork(SimpleHash model, String strutsKey, String webworkKey) {
        try {
            TemplateModel object = model.get(strutsKey);
            if (object != null) {
                model.put(webworkKey, (Object)object);
            }
        }
        catch (TemplateModelException e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    static void setBambooConfigData(Configuration configuration, @Nullable I18nBeanFactory i18nBeanFactory, Supplier<SoyTemplateRenderer> soyTemplateRenderer) {
        if (!BuildUtils.isDevMode()) {
            configuration.setTemplateUpdateDelay(-1);
        }
        configuration.setCacheStorage((CacheStorage)new ConcurrentStrongCacheStorage());
        configuration.setLocalizedLookup(false);
        if (i18nBeanFactory != null) {
            I18nBean i18nBean = i18nBeanFactory.getI18nBean(Locale.getDefault());
            configuration.setDateFormat(i18nBean.getText("global.dateFormat.date"));
            configuration.setDateTimeFormat(i18nBean.getText("global.dateFormat.datetime"));
            configuration.setTimeFormat(i18nBean.getText("global.dateFormat.time"));
            try {
                configuration.setSharedVariable("dateUtils", (Object)new DateUtils(i18nBean.getDefaultResourceBundle()));
            }
            catch (TemplateModelException e) {
                log.error((Object)"Failed to load shared variables. Templates might be rendered incorrectly.", (Throwable)e);
            }
        }
        try {
            BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
            TemplateHashModel enumModels = wrapper.getEnumModels();
            TemplateHashModel webResourceUrlModeEnums = (TemplateHashModel)enumModels.get("com.atlassian.plugin.webresource.UrlMode");
            configuration.setSharedVariable("UrlMode", (TemplateModel)webResourceUrlModeEnums);
            TemplateHashModel prettyLength = (TemplateHashModel)enumModels.get("com.atlassian.bamboo.utils.PrettyLength");
            configuration.setSharedVariable("PrettyLength", (TemplateModel)prettyLength);
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel containUtilModel = (TemplateHashModel)staticModels.get("org.apache.struts2.util.ContainUtil");
            configuration.setSharedVariable("ContainUtil", (TemplateModel)containUtilModel);
        }
        catch (TemplateModelException e) {
            log.error((Object)"Failed to load required web resource Enums for UrlMode", (Throwable)e);
        }
        try {
            configuration.setSharedVariable("soy", (Object)new BambooFreemarkerManagerSoyHelpers.SoyHelper(soyTemplateRenderer));
        }
        catch (TemplateModelException e) {
            log.error((Object)"Failed to load soy template renderer. Templates might be rendered incorrectly.", (Throwable)e);
        }
        configuration.setTagSyntax(0);
        if (!"true".equals(System.getProperty("bamboo.template.renderer.test.mode"))) {
            configuration.addAutoImport("ui", "freemarker-lib/ui.ftl");
            configuration.addAutoImport("help", "freemarker-lib/help.ftl");
            configuration.addAutoImport("fn", "freemarker-lib/functions.ftl");
        }
        try {
            configuration.setSharedVariable("durationUtils", (Object)DurationUtils.getInstance());
            configuration.setSharedVariable("htmlUtils", (Object)HtmlUtils.getInstanceForFreemarker());
            configuration.setSharedVariable("numberUtils", (Object)NumberUtils.getInstance());
            configuration.setSharedVariable("repositoryUtils", (Object)BambooRepositoryUtils.getInstance());
        }
        catch (TemplateModelException e) {
            log.error((Object)"Failed to load shared variables. Templates might be rendered incorrectly.", (Throwable)e);
        }
        configuration.setNumberFormat("0.######");
        BambooFreemarkerManagerHelpers.setTemplateExceptionHandler(configuration);
        configuration.setOutputEncoding("UTF-8");
    }

    static boolean isFreeMarkerDebugModeEnabled() {
        return BuildUtils.isDevMode() && (SystemProperty.BAMBOO_FREEMARKER_DEBUG.getValue(false) || ActionParamsUtils.hasParameter("bamboo.freemarker.debug"));
    }

    static void setTemplateExceptionHandler(Configuration configuration) {
        if (BuildUtils.isDevMode() || BuildUtils.isFunctionalTest()) {
            configuration.setTemplateExceptionHandler((TemplateExceptionHandler)new DebugWithoutThrowingExceptionHandler());
        } else {
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        }
    }
}

