/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plugin.OsgiServiceProxyFactory;
import com.atlassian.bamboo.plugin.xwork.PluginClassTemplateLoader;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.ww2.BambooBeansWrapperListener;
import com.atlassian.bamboo.ww2.BambooFreemarkerManagerHelpers;
import com.atlassian.bamboo.ww2.BareFreeMarkerContextImpl;
import com.atlassian.bamboo.ww2.FreemarkerContext;
import com.atlassian.config.HomeLocator;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperListener;
import freemarker.ext.beans.BeansWrapperListeners;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.ScopesHashModel;
import org.apache.struts2.views.freemarker.StrutsClassTemplateLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.ServletContextAware;

@Internal
public class BambooFreemarkerManager
extends FreemarkerManager
implements TemplateRenderer,
ServletContextAware {
    private static final Logger log = Logger.getLogger(BambooFreemarkerManager.class);
    private static final BambooBeansWrapperListener BAMBOO_BEANS_WRAPPER_LISTENER = new BambooBeansWrapperListener();
    public static final String PARAM_BASE_URL = "baseUrl";
    public static final String PARAM_CONTEXT = "ctx";
    public static final String PARAM_I18N_BEAN = "i18n";
    public static final String PARAM_JIRA_ISSUE_UTILS = "jiraIssueUtils";
    public static final String PARAM_WEB_RESOURCE_MANAGER = "webResourceManager";
    public static final String PARAM_STATIC_RESOURCE_PREFIX = "staticResourcePrefix";
    public static final String PARAM_BAMBOO_PERMISSION_MANAGER = "permissionManager";
    public static final String PARAM_BUILD_UTILS = "buildUtils";
    @Autowired(required=false)
    private FreemarkerContext freemarkerContext;
    @Autowired(required=false)
    private WebResourceManager webResourceManager;
    @Autowired(required=false)
    private WebResourceUrlProvider webResourceUrlProvider;
    @Autowired(required=false)
    private JiraIssueUtils jiraIssueUtils;
    @Autowired(required=false)
    private BambooPermissionManager bambooPermissionManager;
    @Autowired
    private BootstrapManager bootstrapManager;
    @Nullable
    private HomeLocator homeLocator;
    @Nullable
    private PluginAccessor pluginAccessor;
    @Nullable
    private I18nBeanFactory i18nBeanFactory;
    private ServletContext servletContext;
    private OsgiServiceProxyFactory osgiServiceProxyFactory;
    private final Supplier<SoyTemplateRenderer> soyTemplateRenderer = Lazy.supplier((Supplier)new Supplier<SoyTemplateRenderer>(){

        @Override
        public SoyTemplateRenderer get() {
            return (SoyTemplateRenderer)BambooFreemarkerManager.this.osgiServiceProxyFactory.createNonIsolatingProxy(SoyTemplateRenderer.class, 1000L);
        }
    });
    private volatile String bambooEncoding = "UTF-8";
    private final ResettableLazyReference<Configuration> noContextConfig = new ResettableLazyReference<Configuration>(){

        protected Configuration create() throws Exception {
            Configuration configuration = new Configuration();
            BambooFreemarkerManagerHelpers.setBambooConfigData(configuration, BambooFreemarkerManager.this.i18nBeanFactory, BambooFreemarkerManager.this.soyTemplateRenderer);
            configuration.setTemplateLoader((TemplateLoader)BambooFreemarkerManager.this.createMultiTemplateLoader(new TemplateLoader[]{configuration.getTemplateLoader(), new StrutsClassTemplateLoader()}));
            Preconditions.checkNotNull((Object)BambooFreemarkerManager.this.bambooEncoding, (Object)"Encoding can't be null");
            configuration.setEncoding(configuration.getLocale(), BambooFreemarkerManager.this.bambooEncoding);
            configuration.setDefaultEncoding(BambooFreemarkerManager.this.bambooEncoding);
            configuration.setObjectWrapper((ObjectWrapper)BeansWrapper.getDefaultInstance());
            configuration.setWhitespaceStripping(true);
            return configuration;
        }
    };

    public BambooFreemarkerManager() {
        BeansWrapperListeners.register((BeansWrapperListener)BAMBOO_BEANS_WRAPPER_LISTENER);
    }

    public void init(ServletContext servletContext) throws TemplateException {
        super.init(servletContext);
        BambooFreemarkerManagerHelpers.setTemplateExceptionHandler(this.config);
    }

    @Inject(value="struts.i18n.encoding")
    public void setEncoding(String encoding) {
        if (encoding == null) {
            log.error((Object)"Encoding cannot be set to null. Bamboo will not work properly.");
            return;
        }
        if (Objects.equals(encoding, this.bambooEncoding)) {
            return;
        }
        log.info((Object)("Setting encoding to " + encoding));
        super.setEncoding(encoding);
        this.bambooEncoding = encoding;
        this.noContextConfig.reset();
    }

    protected Configuration createConfiguration(ServletContext servletContext) throws TemplateException {
        Configuration configuration = super.createConfiguration(servletContext);
        BambooFreemarkerManagerHelpers.setBambooConfigData(configuration, this.i18nBeanFactory, this.soyTemplateRenderer);
        configuration.addAutoImport("cp", "lib/components.ftl");
        configuration.addAutoImport("dj", "lib/dojo.ftl");
        configuration.addAutoImport("api", "api/rest/macros.ftl");
        return configuration;
    }

    protected TemplateLoader createTemplateLoader(ServletContext servletContext, String ignore) {
        this.templatePath = "disabled";
        return this.createMultiTemplateLoader(super.createTemplateLoader(servletContext, this.templatePath));
    }

    private MultiTemplateLoader createMultiTemplateLoader(TemplateLoader ... templateLoaders) {
        ArrayList<Object> loaders = new ArrayList<Object>();
        BambooCollectionUtils.addIgnoreNull(loaders, (Object)this.createHomeTemplateLoader());
        loaders.addAll(Arrays.asList(templateLoaders));
        loaders.add(new PluginClassTemplateLoader(this.pluginAccessor));
        return new MultiTemplateLoader(loaders.toArray(new TemplateLoader[0]));
    }

    @Nullable
    private FileTemplateLoader createHomeTemplateLoader() {
        File templatePathInHome = this.getTemplatePathInHome();
        if (templatePathInHome == null) {
            return null;
        }
        try {
            return new FileTemplateLoader(templatePathInHome);
        }
        catch (IOException e) {
            log.error((Object)"Failed to create file template loader. Templates might be rendered incorrectly.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private File getTemplatePathInHome() {
        if (this.homeLocator == null || StringUtils.isBlank((CharSequence)this.homeLocator.getHomePath())) {
            return null;
        }
        File homeTemplateDirectory = new File(this.homeLocator.getHomePath(), "templates");
        if (!homeTemplateDirectory.exists()) {
            homeTemplateDirectory.mkdir();
        }
        return homeTemplateDirectory;
    }

    public void populateContext(ScopesHashModel model, ValueStack stack, Object action, HttpServletRequest request, HttpServletResponse response) {
        model.putAll(this.getParamMap());
        super.populateContext(model, stack, action, request, response);
        BambooFreemarkerManagerHelpers.convertStrutsToWebWork((SimpleHash)model, "request", "req");
        BambooFreemarkerManagerHelpers.convertStrutsToWebWork((SimpleHash)model, "response", "res");
        BambooFreemarkerManagerHelpers.convertStrutsToWebWork((SimpleHash)model, "struts", "webwork");
    }

    @Nullable
    public String render(@Nullable String templatePath, @Nullable Map<String, Object> contextParams) {
        if (templatePath == null) {
            return null;
        }
        return this.renderPage(templatePath, contextParams);
    }

    @NotNull
    public String renderPage(@NotNull String templatePath, Map<String, Object> params) {
        return this.renderTemplateToString(templatePath, params, true);
    }

    @NotNull
    public String renderWithoutActionContext(@Nullable String templatePath, @NotNull Map<String, Object> contextParams) {
        if (templatePath == null) {
            return "";
        }
        return this.renderTemplateToString(templatePath, contextParams, false);
    }

    private void renderPage(@NotNull String templatePath, @Nullable Map<String, Object> params, @NotNull Writer writer, boolean useActionContext) throws IOException, TemplateException {
        if (useActionContext) {
            this.renderPage(templatePath, params, writer);
        } else {
            this.renderPageWithNoContext(templatePath, params, writer);
        }
    }

    public void render(String templatePath, @Nullable Map<String, Object> contextParams, @NotNull Writer writer) throws IOException {
        try {
            this.renderPage(templatePath, contextParams, writer);
        }
        catch (TemplateException te) {
            log.error((Object)"Error rendering template", (Throwable)te);
            te.printStackTrace(new PrintWriter(writer));
        }
    }

    private void renderPage(@NotNull String templatePath, @Nullable Map<String, Object> params, @NotNull Writer writer) throws IOException, TemplateException {
        ActionContext ctx = ActionContext.getContext();
        if (ctx == null) {
            this.renderPageWithNoContext(templatePath, params, writer);
            return;
        }
        HttpServletRequest req = RequestCacheThreadLocal.getRequest();
        HttpServletResponse res = RequestCacheThreadLocal.getResponse();
        Configuration config = this.getConfiguration(this.servletContext);
        ActionInvocation invocation = ctx.getActionInvocation();
        Locale locale = invocation.getAction() instanceof LocaleProvider ? ((LocaleProvider)invocation.getAction()).getLocale() : config.getLocale();
        Template template = config.getTemplate(templatePath, locale);
        ScopesHashModel model = this.buildTemplateModel(ctx.getValueStack(), null, this.servletContext, req, res, config.getObjectWrapper());
        if (params != null) {
            model.putAll(params);
        }
        template.process((Object)model, writer);
    }

    private void renderPageWithNoContext(@NotNull String templatePath, @NotNull Map<String, Object> params, Writer writer) throws IOException, TemplateException {
        Configuration configuration = (Configuration)this.noContextConfig.get();
        HashMap<String, Object> templateData = new HashMap<String, Object>(params);
        templateData.putAll(this.getParamMap());
        templateData.put(PARAM_BASE_URL, this.getAdminConfiguration().getBaseUrl());
        Template template = configuration.getTemplate(templatePath);
        template.process(templateData, writer);
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (BambooFreemarkerManager.getBootstrapManager(this.bootstrapManager).isSetupComplete()) {
            params.put(PARAM_WEB_RESOURCE_MANAGER, this.webResourceManager);
            params.put(PARAM_STATIC_RESOURCE_PREFIX, this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO));
            params.put(PARAM_CONTEXT, this.freemarkerContext);
            params.put(PARAM_JIRA_ISSUE_UTILS, this.jiraIssueUtils);
            params.put(PARAM_BAMBOO_PERMISSION_MANAGER, this.bambooPermissionManager);
        } else {
            params.put(PARAM_JIRA_ISSUE_UTILS, JiraIssueUtils.getFreemarkerInstance());
            params.put(PARAM_CONTEXT, BareFreeMarkerContextImpl.INSTANCE);
        }
        params.put(PARAM_BUILD_UTILS, BuildUtils.getFreemarkerInstance());
        if (this.i18nBeanFactory != null) {
            params.put(PARAM_I18N_BEAN, this.i18nBeanFactory.getI18nBean(Locale.getDefault()));
        }
        return params;
    }

    private static AtlassianBootstrapManager getBootstrapManager(@Nullable BootstrapManager bootstrapManager) {
        return bootstrapManager != null ? bootstrapManager : BootstrapUtils.getBootstrapManager();
    }

    private String renderTextWithNoContext(@NotNull String text, Map<String, Object> params) {
        Configuration configuration = (Configuration)this.noContextConfig.get();
        HashMap<String, Object> templateData = new HashMap<String, Object>(params);
        templateData.putAll(this.getParamMap());
        templateData.put(PARAM_BASE_URL, this.getAdminConfiguration().getBaseUrl());
        try {
            Template template = new Template("URLTemplate", (Reader)new StringReader(text), configuration);
            StringWriter out = new StringWriter();
            template.process(templateData, (Writer)out);
            return out.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error while rendering template", (Throwable)e);
            return ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    @NotNull
    public String renderText(@NotNull String text, Map<String, Object> params) {
        try {
            ActionContext ctx = ActionContext.getContext();
            if (ctx == null) {
                return this.renderTextWithNoContext(text, params);
            }
            HttpServletRequest req = RequestCacheThreadLocal.getRequest();
            ResponseWrapper res = new ResponseWrapper(RequestCacheThreadLocal.getResponse());
            Configuration config = this.getConfiguration(this.servletContext);
            Template template = new Template("URLTemplate", (Reader)new StringReader(text), config);
            ScopesHashModel model = this.buildTemplateModel(ctx.getValueStack(), null, this.servletContext, req, (HttpServletResponse)res, config.getObjectWrapper());
            if (params != null) {
                model.putAll(params);
            }
            template.process((Object)model, (Writer)res.getWriter());
            return res.getData();
        }
        catch (Exception e) {
            log.error((Object)"Error while rendering template", (Throwable)e);
            return ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public void clearCaches() {
        BAMBOO_BEANS_WRAPPER_LISTENER.reset();
        this.noContextConfig.reset();
        if (this.config != null) {
            log.debug((Object)"Freemarker caches have been invalidated");
            this.config.clearTemplateCache();
        }
    }

    @NotNull
    private String renderTemplateToString(@NotNull String templatePath, @NotNull Map<String, Object> contextParams, boolean useActionContext) {
        try {
            StringWriter writer = new StringWriter();
            this.renderPage(templatePath, contextParams, writer, useActionContext);
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)("Error while rendering template: " + templatePath), (Throwable)e);
            return ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    private AdministrationConfiguration getAdminConfiguration() {
        Persister persister = PersisterFactory.getInstance();
        return persister.getAdministrationConfiguration();
    }

    public void setHomeLocator(@Nullable HomeLocator homeLocator) {
        this.homeLocator = homeLocator;
        this.noContextConfig.reset();
    }

    public void setPluginAccessor(@Nullable PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.noContextConfig.reset();
    }

    public void setI18nBeanFactory(@Nullable I18nBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
        this.noContextConfig.reset();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setOsgiServiceProxyFactory(OsgiServiceProxyFactory osgiServiceProxyFactory) {
        this.osgiServiceProxyFactory = osgiServiceProxyFactory;
    }

    public ScopesHashModel buildTemplateModel(ValueStack stack, @Nullable Object action, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        ScopesHashModel simpleHash = super.buildTemplateModel(stack, action, servletContext, request, response, wrapper);
        BambooFreemarkerManagerHelpers.convertStrutsToWebWork((SimpleHash)simpleHash, "s", "ww");
        return simpleHash;
    }

    static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        StringWriter writer;

        ServletOutputStreamWrapper(StringWriter aWriter) {
            this.writer = aWriter;
        }

        public void write(int aByte) {
            this.writer.write(aByte);
        }
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        StringWriter strout = new StringWriter();
        PrintWriter writer;
        ServletOutputStream sout = new ServletOutputStreamWrapper(this.strout);

        ResponseWrapper(HttpServletResponse aResponse) {
            super(aResponse);
            this.writer = new PrintWriter(this.strout);
        }

        @NotNull
        public String getData() {
            this.writer.flush();
            return this.strout.toString();
        }

        public ServletOutputStream getOutputStream() {
            return this.sout;
        }

        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }
    }
}

