/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2;

import com.atlassian.bamboo.Bamboo;
import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.ServerLifecycleProvider;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.CookieCutter;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.jsonator.Jsonator;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.rest.BambooRemoteException;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.session.BambooSession;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.struts.JsonStreamingAction;
import com.atlassian.bamboo.task.TaskCategory;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.utils.UrlUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.utils.i18n.TextProviderAdapter;
import com.atlassian.bamboo.ww2.KeyAccessTrackingMap;
import com.atlassian.bamboo.ww2.NavigationContext;
import com.atlassian.bamboo.ww2.aware.BambooSessionAware;
import com.atlassian.bamboo.ww2.aware.BuildResultsAware;
import com.atlassian.bamboo.ww2.aware.BuildResultsSummaryAware;
import com.atlassian.bamboo.ww2.aware.BuildableAware;
import com.atlassian.bamboo.ww2.aware.NavigationAware;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.bamboo.ww2.aware.ReturnUrlAware;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalReadSecurityAware;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.atlassian.breadcrumbs.ProjectCrumb;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.i18n.I18nTextProvider;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.seraph.config.RedirectPolicy;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.User;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.LocalizedTextProvider;
import com.opensymphony.xwork2.TextProviderSupport;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.ognl.OgnlValueStack;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ValidatorContext;
import freemarker.core.profiler.FreemarkerProfiler;
import io.atlassian.util.concurrent.Lazy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooActionSupport
extends ActionSupport
implements ErrorCollection,
ReturnUrlAware,
BambooSessionAware,
GlobalReadSecurityAware,
I18nTextProvider,
NavigationAware,
com.opensymphony.xwork.ValidationAware,
com.atlassian.struts.ValidationAware,
TextProvider,
JsonStreamingAction {
    private static final Logger log = Logger.getLogger(BambooActionSupport.class);
    private static final String ATLASSIAN_BAMBOO_SESSION = "atlassian.bamboo.session.holder";
    public static final String CONFIRM = "confirm";
    public static final String ACCESS_DENIED = "accessDenied";
    public static final String PAGE_NOT_FOUND = "fourOhFour";
    public static final String PLAN_KEY_CONTEXT = "planKey";
    public static final String BUILD_KEY_CONTEXT = "buildKey";
    public static final String AGGREGATE_URL_PATTERN = "/browse/%s/aggregate?%s=%s";
    private BambooUrl bambooUrl;
    private Set<String> fieldErrorAccessTracker = new HashSet<String>();
    private LocalizedTextProvider localizedTextProvider;
    private String returnUrl;
    private List<BreadCrumb> crumbs;
    private Map<String, Object> webFragmentsContextMap;
    private boolean enableJavascript = true;
    private JSONObject jsonObject;
    private Set<String> checkBoxFields;
    private NavigationContext navigationContext;
    private String chainEquiv;
    private String jobEquiv;
    private String decorator;
    private final List<String> actionWarnings = new ArrayList<String>();
    private final List<String> helpPanels = new ArrayList<String>();
    private Bamboo bamboo;
    protected AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Deprecated
    protected AdministrationConfigurationManager administrationConfigurationManager;
    protected AdministrationConfigurationPersister administrationConfigurationPersister;
    protected BambooAuthenticationContext authenticationContext;
    private BambooLicenseManager bambooLicenseManager;
    protected BambooPermissionManager bambooPermissionManager;
    protected BambooUserManager bambooUserManager;
    protected BuildDefinitionManager buildDefinitionManager;
    protected CachedPlanManager cachedPlanManager;
    protected CookieCutter cookieCutter;
    private DocumentationLinkProvider documentationLinkProvider;
    protected FeatureManager featureManager;
    private I18nBeanFactory i18nBeanFactory;
    protected PlanExecutionManager planExecutionManager;
    protected PlanManager planManager;
    protected PluginAccessor pluginAccessor;
    protected ProjectManager projectManager;
    private EnvironmentService environmentService;
    protected DeploymentProjectService deploymentProjectService;
    private ServerLifecycleProvider serverLifecycleProvider;
    private com.opensymphony.xwork2.TextProvider textProvider;
    protected WebInterfaceManager webInterfaceManager;
    private Supplier<User> user = Lazy.supplier(() -> this.authenticationContext.getUser());
    private String currentFormTheme;
    private Jsonator jsonator;

    public void setProfile(String value) {
        FreemarkerProfiler.startProfiling();
    }

    @Deprecated
    public String doDefault() throws Exception {
        return "input";
    }

    @Override
    public BambooSession getBambooSession() {
        HttpSession session = ServletActionContext.getRequest().getSession(true);
        BambooSession bambooSession = (BambooSession)session.getAttribute(ATLASSIAN_BAMBOO_SESSION);
        if (bambooSession == null) {
            bambooSession = new BambooSession();
            ContainerManager.autowireComponent((Object)bambooSession);
            session.setAttribute(ATLASSIAN_BAMBOO_SESSION, (Object)bambooSession);
        }
        return bambooSession;
    }

    protected Bamboo getBamboo() {
        if (this.bamboo == null) {
            this.bamboo = (Bamboo)ActionContext.getContext().getApplication().get("com.atlassian.bamboo.Bamboo");
        }
        return this.bamboo;
    }

    @Nullable
    public User getUser() {
        return this.user.get();
    }

    @NotNull
    public ServerLifecycleState getServerLifecycleState() {
        return this.serverLifecycleProvider.getServerLifecycleState();
    }

    public void setServerLifecycleProvider(ServerLifecycleProvider serverLifecycleProvider) {
        this.serverLifecycleProvider = serverLifecycleProvider;
    }

    public boolean doesLabelKeyHaveMatchingDescription(String labelKey) {
        String descriptionKey = labelKey + ".description";
        return this.hasKey(descriptionKey);
    }

    public boolean doesHelpLinkHaveMatchingTitle(String helpKey) {
        String descriptionKey = helpKey + ".title";
        return this.hasKey(descriptionKey);
    }

    public String getDescriptionFromLabelKey(String labelKey) {
        return this.getText(labelKey + ".description");
    }

    public boolean hasGlobalPermission(String permission) {
        return this.hasGlobalPermission(BambooPermission.buildFromName((String)permission));
    }

    public boolean hasGlobalPermission(Permission permission) {
        return this.bambooPermissionManager.hasGlobalPermission(permission);
    }

    public boolean hasGlobalAdminPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
    }

    public boolean hasRestrictedAdminPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
    }

    public boolean hasAdminPermission() {
        return this.hasGlobalAdminPermission() || this.hasRestrictedAdminPermission();
    }

    public boolean hasPlanPermission(String permission, String planKey) {
        try {
            return this.bambooPermissionManager.hasPlanPermission(BambooPermission.buildFromName((String)permission), PlanKeys.getPlanKey((String)planKey));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Incorrect plan key passed to hasPlanPermission: " + planKey));
            return false;
        }
    }

    public boolean hasPlanPermission(String permission, PlanIdentifier plan) {
        return this.bambooPermissionManager.hasPermission(BambooPermission.buildFromName((String)permission), (Object)plan, null);
    }

    public boolean hasEntityPermission(String permission, Object object) {
        return this.bambooPermissionManager.hasPermission(BambooPermission.buildFromName((String)permission), object, null);
    }

    public boolean hasResultKeyReadPermission(ResultKey resultKey) {
        String key = resultKey.getKey();
        if (PlanKeys.isPlanKey((String)key)) {
            PlanKey planKey = PlanKeys.getChainKeyFromJobKey((PlanKey)PlanKeys.getPlanKey((String)key));
            return this.hasPlanPermission("READ", planKey.getKey());
        }
        Key environmentKey = resultKey.getEntityKey();
        long environmentId = Long.parseLong(StringUtils.split((String)environmentKey.getKey(), (char)'-')[1]);
        try {
            this.environmentService.getEnvironment(environmentId);
        }
        catch (AccessDeniedException ignored) {
            return false;
        }
        return true;
    }

    public boolean isRestrictedAdminEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isEnableRestrictedAdmin();
    }

    public boolean isEnableSignup() {
        return this.bambooPermissionManager.isEnableSignup();
    }

    public boolean getConcurrentBuildsEnabled() {
        return this.getAdministrationConfiguration().getConcurrentBuildConfig().isEnabled();
    }

    public boolean isViewContactDetailsEnabled() {
        return this.getAdministrationConfiguration().isEnableViewContactDetails();
    }

    public boolean hasBuilds() {
        return this.cachedPlanManager.getAnyPlan(ImmutableTopLevelPlan.class::isInstance).isPresent();
    }

    @Nullable
    public ImmutableChain getPlan(String planKey) {
        return (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(PlanKeys.getPlanKey((String)planKey), ImmutableChain.class);
    }

    public Collection<BreadCrumb> getBreadCrumbs() {
        if (this.crumbs == null) {
            this.crumbs = Collections.singletonList(new ProjectCrumb(ServletActionContext.getRequest(), (Action)this));
        }
        return this.crumbs;
    }

    public void setAuthenticationContext(BambooAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    protected void forceRelativeReturnUrl() {
        this.returnUrl = UrlUtils.getPathUnderContext((String)this.returnUrl, (String)ServletActionContext.getRequest().getContextPath());
    }

    @Override
    public String getReturnUrl() {
        return this.makeSafeRedirectUrl(this.returnUrl);
    }

    @Override
    public void setReturnUrl(String returnUrl) {
        if (returnUrl == null) {
            this.returnUrl = null;
            return;
        }
        Preconditions.checkArgument((boolean)UrlUtils.isSafeUrl((String)returnUrl), (String)"Wrong return url: %s", (Object)returnUrl);
        this.returnUrl = returnUrl;
    }

    String makeSafeRedirectUrl(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            HttpServletRequest request = RequestCacheThreadLocal.getRequest();
            SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
            RedirectPolicy redirectPolicy = securityConfig.getRedirectPolicy();
            if (request == null || !redirectPolicy.allowedRedirectDestination(url, request)) {
                return this.getBambooUrl().getBaseUrl(UrlMode.ABSOLUTE);
            }
        }
        return url;
    }

    @Nullable
    public String getCurrentUrl() {
        try {
            return BambooUrl.getCurrentPathAndQuery();
        }
        catch (IllegalStateException e) {
            log.warn((Object)e.toString());
            log.debug(null, (Throwable)e);
            return null;
        }
    }

    public Long getCurrentSystemTime() {
        return System.currentTimeMillis();
    }

    @NotNull
    public String getCookieValue(String key) {
        return this.cookieCutter.getValueFromCookie(key);
    }

    protected BambooLicenseManager getBambooLicenseManager() {
        return this.bambooLicenseManager;
    }

    public void setBambooLicenseManager(BambooLicenseManager bambooLicenseManager) {
        this.bambooLicenseManager = bambooLicenseManager;
    }

    public BootstrapManager getBootstrapManager() {
        return (BootstrapManager)BootstrapUtils.getBootstrapManager();
    }

    public List<WebItemModuleDescriptor> getWebItemsForSection(String sectionName) {
        List displayableItems = this.webInterfaceManager.getDisplayableItems(sectionName, this.getWebFragmentsContextMap());
        return displayableItems;
    }

    public List<WebSectionModuleDescriptor> getWebSectionsForLocation(String location) {
        return this.webInterfaceManager.getDisplayableSections(location, this.getWebFragmentsContextMap());
    }

    public String renderFreemarkerTemplate(String templateString) {
        return this.webInterfaceManager.getWebFragmentHelper().renderVelocityFragment(templateString, this.getWebFragmentsContextMap());
    }

    public Map<String, Object> getWebFragmentsContextMap() {
        if (this.webFragmentsContextMap != null) {
            return this.webFragmentsContextMap;
        }
        HttpParameters map = ServletActionContext.getContext().getParameters();
        this.webFragmentsContextMap = new HashMap<String, Object>();
        this.webFragmentsContextMap.put("user", this.getUser());
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = ((Parameter)entry.getValue()).getObject();
            if (value instanceof String[]) {
                String[] strArray = (String[])value;
                this.webFragmentsContextMap.put(key, strArray[0]);
                continue;
            }
            this.webFragmentsContextMap.put(key, value);
        }
        if (this.webFragmentsContextMap.containsKey(PLAN_KEY_CONTEXT) && !this.webFragmentsContextMap.containsKey(BUILD_KEY_CONTEXT)) {
            this.webFragmentsContextMap.put(BUILD_KEY_CONTEXT, this.webFragmentsContextMap.get(PLAN_KEY_CONTEXT));
        } else if (this.webFragmentsContextMap.containsKey(BUILD_KEY_CONTEXT) && !this.webFragmentsContextMap.containsKey(PLAN_KEY_CONTEXT)) {
            this.webFragmentsContextMap.put(PLAN_KEY_CONTEXT, this.webFragmentsContextMap.get(BUILD_KEY_CONTEXT));
        }
        if (!this.webFragmentsContextMap.containsKey(BUILD_KEY_CONTEXT)) {
            BuildableAware buildAware;
            ImmutableBuildable build;
            if (this instanceof PlanAware) {
                PlanAware planAware = (PlanAware)((Object)this);
                ImmutablePlan plan = planAware.getImmutablePlan();
                if (plan != null) {
                    this.webFragmentsContextMap.put(BUILD_KEY_CONTEXT, plan.getKey());
                    this.webFragmentsContextMap.put(PLAN_KEY_CONTEXT, plan.getKey());
                }
            } else if (this instanceof BuildableAware && (build = (buildAware = (BuildableAware)((Object)this)).getImmutableBuild()) != null) {
                this.webFragmentsContextMap.put(BUILD_KEY_CONTEXT, build.getKey());
                this.webFragmentsContextMap.put(PLAN_KEY_CONTEXT, build.getKey());
            }
            if (!this.webFragmentsContextMap.containsKey("buildNumber")) {
                ResultsSummary buildResults;
                Object buildResultsAware;
                if (this instanceof ResultsSummaryAware) {
                    buildResultsAware = (ResultsSummaryAware)((Object)this);
                    buildResults = buildResultsAware.getResultsSummary();
                    if (buildResults != null) {
                        this.webFragmentsContextMap.put(PLAN_KEY_CONTEXT, buildResults.getPlanKey().toString());
                        this.webFragmentsContextMap.put(BUILD_KEY_CONTEXT, buildResults.getPlanKey().toString());
                        this.webFragmentsContextMap.put("buildNumber", String.valueOf(buildResults.getBuildNumber()));
                    }
                } else if (this instanceof BuildResultsSummaryAware) {
                    buildResultsAware = (BuildResultsSummaryAware)((Object)this);
                    buildResults = buildResultsAware.getBuildResultsSummary();
                    if (buildResults != null) {
                        this.webFragmentsContextMap.put(PLAN_KEY_CONTEXT, buildResults.getPlanKey().toString());
                        this.webFragmentsContextMap.put(BUILD_KEY_CONTEXT, buildResults.getPlanKey().toString());
                        this.webFragmentsContextMap.put("buildNumber", String.valueOf(buildResults.getBuildNumber()));
                    }
                } else if (this instanceof BuildResultsAware && (buildResults = (buildResultsAware = (BuildResultsAware)((Object)this)).getBuildResults()) != null) {
                    this.webFragmentsContextMap.put(PLAN_KEY_CONTEXT, buildResults.getBuildKey());
                    this.webFragmentsContextMap.put(BUILD_KEY_CONTEXT, buildResults.getBuildKey());
                    this.webFragmentsContextMap.put("buildNumber", String.valueOf(buildResults.getBuildNumber()));
                }
            }
        }
        return this.webFragmentsContextMap;
    }

    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        if (this.jsonObject == null) {
            this.jsonObject = this.buildJsonObject();
        }
        return this.jsonObject;
    }

    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = new JSONObject();
        if (this.hasErrors()) {
            result.put("status", (Object)JSONStatus.ERROR);
            if (this.hasActionErrors()) {
                result.put("errors", this.getActionErrors());
            }
            if (this.hasFieldErrors()) {
                JSONObject jsonFieldErrors = new JSONObject();
                Map<String, List<String>> fieldErrors = this.getFieldErrors();
                for (Map.Entry<String, List<String>> fieldError : fieldErrors.entrySet()) {
                    jsonFieldErrors.put(fieldError.getKey(), (Collection)fieldError.getValue());
                }
                result.put("fieldErrors", (Object)jsonFieldErrors);
            }
        } else {
            result.put("status", (Object)JSONStatus.OK);
            if (this.hasActionMessages()) {
                result.put("messages", this.getActionMessages());
            }
        }
        if (this.hasActionWarnings()) {
            result.put("warnings", this.getActionWarnings());
        }
        return result;
    }

    @Override
    public void streamJson(JsonStream stream) throws IOException, JSONException {
        if (this.hasErrors()) {
            stream.put("status", (Object)JSONStatus.ERROR);
            if (this.hasActionErrors()) {
                stream.put("errors", this.getActionErrors());
            }
            if (this.hasFieldErrors()) {
                stream.put("fieldErrors", this.getFieldErrors());
            }
        } else {
            stream.put("status", (Object)JSONStatus.OK);
            if (this.hasActionMessages()) {
                stream.put("messages", this.getActionMessages());
            }
        }
        if (this.hasActionWarnings()) {
            stream.put("warnings", this.getActionWarnings());
        }
    }

    protected void addActionError(@NotNull Exception exception) {
        log.error((Object)exception, (Throwable)exception);
        String message = exception.getMessage();
        super.addActionError((String)MoreObjects.firstNonNull((Object)message, (Object)exception.getClass().toString()));
    }

    public void addActionError(@Nullable String errorMessage) {
        String notNullErrorMessage = (String)StringUtils.defaultIfEmpty((CharSequence)errorMessage, (CharSequence)"Unknown error");
        super.addActionError(notNullErrorMessage);
        if (BuildUtils.isDevMode()) {
            log.error((Object)notNullErrorMessage, new Throwable());
        }
    }

    public boolean hasActionWarnings() {
        return !this.actionWarnings.isEmpty();
    }

    @NotNull
    public List<String> getActionWarnings() {
        return this.actionWarnings;
    }

    public void addActionWarning(@Nullable String errorMessage) {
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            this.actionWarnings.add(errorMessage);
        }
    }

    public void addError(String prefix, String field, String message) {
        this.addFieldError(prefix + "." + field, message);
    }

    public Collection<String> getFlushedErrorMessages() {
        Collection errorMessages = this.getActionErrors();
        this.setActionErrors(new ArrayList());
        return errorMessages;
    }

    public void addErrorCollection(@NotNull ErrorCollection errors) {
        this.addErrorMessages(errors.getErrorMessages());
        this.addFieldErrors(errors.getFieldErrors());
    }

    public void addErrorMessages(Collection<String> errorMessages) {
        Collection currentErrorMessages = this.getActionErrors();
        currentErrorMessages.addAll(errorMessages);
        this.setActionErrors(currentErrorMessages);
    }

    @Deprecated
    public Map<String, List<String>> getErrors() {
        throw new UnsupportedOperationException("Use getFieldErrors instead");
    }

    @Deprecated
    public Collection<String> getErrorMessages() {
        throw new UnsupportedOperationException("Use getActionErrors instead");
    }

    @Deprecated
    public void addErrors(Map<String, ?> errors) {
        for (Map.Entry<String, ?> entry : errors.entrySet()) {
            String fieldKey = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Iterable) {
                for (String message : (Iterable)value) {
                    this.addFieldError(fieldKey, message);
                }
                continue;
            }
            if (value instanceof String) {
                this.addFieldError(fieldKey, (String)value);
                continue;
            }
            throw new IllegalArgumentException("Added error value must be an Iterable or a String, not " + value.getClass().getCanonicalName() + ". Object is " + value + " and key is " + fieldKey);
        }
    }

    public void addFieldErrors(@NotNull Map<String, List<String>> errors) {
        for (Map.Entry<String, List<String>> fieldNameAndErrors : errors.entrySet()) {
            for (String error : fieldNameAndErrors.getValue()) {
                this.addFieldError(fieldNameAndErrors.getKey(), error);
            }
        }
    }

    public boolean hasAnyErrors() {
        return this.hasErrors();
    }

    public int getTotalErrors() {
        return this.getFieldErrors().size() + this.getActionErrors().size();
    }

    public Map<String, List<String>> getFieldErrors() {
        return new KeyAccessTrackingMap<String, List<String>>(super.getFieldErrors(), this.fieldErrorAccessTracker);
    }

    @Deprecated
    public void addError(String field, String message) {
        this.addFieldError(field, message);
    }

    @Deprecated
    public String addErrorMessage(String message) {
        this.addActionError(message);
        return message;
    }

    @Deprecated
    public void setErrorMessages(Collection<String> errorMessages) {
        this.setActionErrors(errorMessages);
    }

    public String addErrorMessage(String message, Exception e) {
        String s = message + "\n" + ExceptionUtils.getStackTrace((Throwable)e);
        this.addActionError(s);
        return s;
    }

    public void addIllegalArgumentException(String field, IllegalArgumentException e) {
        this.addFieldError(field, e.getMessage());
    }

    public void setCookieCutter(CookieCutter cookieCutter) {
        this.cookieCutter = cookieCutter;
    }

    public CookieCutter getCookieCutter() {
        return this.cookieCutter;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    protected BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public boolean isSelectFieldAndNull(String buildKeysField) {
        HttpParameters parameters = ActionContext.getContext().getParameters();
        Parameter selectFields = parameters.get((Object)"selectFields");
        if (!selectFields.isDefined()) {
            return false;
        }
        for (String selectField : selectFields.getMultipleValues()) {
            if (!buildKeysField.equals(selectField) || parameters.get((Object)selectField).isDefined()) continue;
            return true;
        }
        return false;
    }

    public String getConglomerateCookieValue(String cookieKey, String conglomerateKey) {
        String cookieValue = this.getCookieValue(cookieKey);
        if (StringUtils.isEmpty((CharSequence)cookieValue)) {
            return "";
        }
        String[] cookieParts = cookieValue.split("\\|");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cookie size for " + cookieKey + ": " + cookieValue.length()));
            log.debug((Object)("CookieParts: " + cookieParts.length));
        }
        for (String cookiePart : cookieParts) {
            if (!cookiePart.startsWith(conglomerateKey)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cookie Found: " + cookiePart));
            }
            return StringUtils.substringAfterLast((String)cookiePart, (String)"-");
        }
        return "";
    }

    @Deprecated
    protected Persister getDefaultPersister() {
        return this.getBamboo().getDefaultPersister();
    }

    protected boolean areCheckBoxesEmpty(String field) {
        HttpParameters parameters = ActionContext.getContext().getParameters();
        Parameter checkBoxes = parameters.get((Object)field);
        return !checkBoxes.isDefined();
    }

    @NotNull
    protected AdministrationConfiguration getAdministrationConfiguration() {
        Preconditions.checkState((this.administrationConfigurationAccessor != null ? 1 : 0) != 0, (Object)"AdministrationConfigurationAccessor is not available");
        return this.administrationConfigurationAccessor.getAdministrationConfiguration();
    }

    @Nullable
    public String getBaseUrl() {
        return this.getAdministrationConfiguration().getBaseUrl();
    }

    public BambooUrl getBambooUrl() {
        if (this.bambooUrl == null) {
            this.bambooUrl = new BambooUrl(this.administrationConfigurationAccessor);
        }
        return this.bambooUrl;
    }

    @Nullable
    public String getBestBaseUrl() {
        String baseUrlFromContext = this.getBaseUrlFromContext();
        return baseUrlFromContext != null ? baseUrlFromContext : this.getBaseUrl();
    }

    @Nullable
    private String getBaseUrlFromContext() {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null) {
            return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        }
        return null;
    }

    @Nullable
    public String getInstanceName() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        return administrationConfiguration != null ? administrationConfiguration.getInstanceName() : null;
    }

    protected void checkFieldXssSafety(String fieldName, String fieldValue) {
        BambooFieldValidate.checkFieldXssSafety((com.atlassian.struts.ValidationAware)this, (com.opensymphony.xwork2.TextProvider)this.getTextProvider(), (String)fieldName, (String)fieldValue);
    }

    protected DelegatingValidatorContext getValidatorContext() {
        return new DelegatingValidatorContext((ValidationAware)this, (com.opensymphony.xwork2.TextProvider)this, (LocaleProvider)this);
    }

    @Nullable
    protected <T extends FieldValidator> T createFieldValidator(@NotNull String fieldName, @NotNull Class<T> validatorClass, @NotNull String messageKey, @Nullable String[] messageParameters) {
        try {
            FieldValidator validator = (FieldValidator)validatorClass.newInstance();
            validator.setValidatorContext((ValidatorContext)this.getValidatorContext());
            validator.setFieldName(fieldName);
            validator.setMessageKey(messageKey);
            validator.setMessageParameters(messageParameters);
            validator.setValueStack(ActionContext.getContext().getValueStack());
            return (T)validator;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.warn((Object)String.format("Cannot create validator of class %s for field %s", validatorClass.getName(), fieldName), (Throwable)e);
            return null;
        }
    }

    public String getText(String s, Object[] objects) {
        return this.getText(s, (String[])objects);
    }

    protected com.opensymphony.xwork2.TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = this.i18nBeanFactory == null ? new TextProviderSupport(this.getClass(), (LocaleProvider)this, this.localizedTextProvider) : new TextProviderAdapter(this.i18nBeanFactory.getI18nBean(this.getLocale()));
        }
        return this.textProvider;
    }

    public boolean hasKey(String key) {
        return this.getTextProvider().hasKey(key);
    }

    public String getText(String key) {
        return this.getTextProvider().getText(key);
    }

    public String getText(String key, String defaultValue) {
        return this.getTextProvider().getText(key, defaultValue);
    }

    public String getText(String key, String defaultValue, String obj) {
        return this.getTextProvider().getText(key, defaultValue, obj);
    }

    public String getText(String key, List args) {
        return this.getTextProvider().getText(key, args);
    }

    public String getText(String key, String[] args) {
        return this.getTextProvider().getText(key, args);
    }

    public String getTextWithArgs(String key, String ... args) {
        return this.getTextProvider().getText(key, args);
    }

    public String getText(String key, String defaultValue, List args) {
        return this.getTextProvider().getText(key, defaultValue, args);
    }

    public String getText(String key, String defaultValue, String[] args) {
        return this.getTextProvider().getText(key, defaultValue, args);
    }

    @Deprecated
    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, (ValueStack)stack);
    }

    @Deprecated
    public String getText(String key, String defaultValue, String[] args, OgnlValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, (ValueStack)stack);
    }

    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, stack);
    }

    public String getText(String key, String defaultValue, List args, ValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, stack);
    }

    public ResourceBundle getTexts(String bundleName) {
        return this.getTextProvider().getTexts(bundleName);
    }

    public ResourceBundle getTexts() {
        return this.getTextProvider().getTexts();
    }

    public void setCheckBoxFields(String[] checkBoxFields) {
        this.checkBoxFields = Sets.newHashSet((Object[])checkBoxFields);
    }

    public boolean isCheckboxSetInAction(@NotNull String checkboxName) {
        return BambooCollectionUtils.contains(this.checkBoxFields, (Object)checkboxName);
    }

    @Override
    public String getNavigationUrl() {
        return this.getCurrentUrl();
    }

    @Override
    public String getChainEquiv() {
        return this.chainEquiv;
    }

    public void setChainEquiv(String chainEquiv) {
        this.chainEquiv = chainEquiv;
    }

    @Override
    public String getJobEquiv() {
        return this.jobEquiv;
    }

    public void setJobEquiv(String jobEquiv) {
        this.jobEquiv = jobEquiv;
    }

    @Override
    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    @Override
    public NavigationContext getNavigationContext() {
        return this.navigationContext;
    }

    public int getNumberOfCurrentlyBuildingPlans(String planKey) {
        return this.planExecutionManager.numberOfExecutions(PlanKeys.getPlanKey((String)planKey));
    }

    @Override
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public BambooUser getSessionUser(String auth) throws BambooRemoteException {
        return this.getBambooUserManager().getBambooUser(this.getBamboo().getSessionManager().getUserNameFromSession(auth));
    }

    public boolean isEnableJavascript() {
        return this.enableJavascript;
    }

    public void setEnableJavascript(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
    }

    public String getCurrentFormTheme() {
        return this.currentFormTheme;
    }

    public void setCurrentFormTheme(String currentFormTheme) {
        this.currentFormTheme = currentFormTheme;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setAdministrationConfigurationManager(AdministrationConfigurationManager administrationConfigurationManager) {
        this.administrationConfigurationManager = administrationConfigurationManager;
    }

    public void setAdministrationConfigurationPersister(AdministrationConfigurationPersister administrationConfigurationPersister) {
        this.administrationConfigurationPersister = administrationConfigurationPersister;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setEnvironmentService(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    public void setDeploymentProjectService(DeploymentProjectService deploymentProjectService) {
        this.deploymentProjectService = deploymentProjectService;
    }

    public void setBuildDefinitionManager(BuildDefinitionManager buildDefinitionManager) {
        this.buildDefinitionManager = buildDefinitionManager;
    }

    public PlanManager getPlanManager() {
        return this.planManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setPlanExecutionManager(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
    }

    public void setI18nBeanFactory(I18nBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public void setJsonator(Jsonator jsonator) {
        this.jsonator = jsonator;
    }

    public Collection<String> getFormattedActionErrors() {
        return this.getActionErrors().stream().map(BambooStringUtils::encodeHtmlWithTagWhiteList).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<String> getFormattedActionMessages() {
        return this.getActionMessages().stream().map(BambooStringUtils::encodeHtmlWithTagWhiteList).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<String> getFormattedActionWarnings() {
        return this.getActionWarnings().stream().map(BambooStringUtils::encodeHtmlWithTagWhiteList).collect(Collectors.toCollection(LinkedList::new));
    }

    @NotNull
    public final Map<String, Object> getWebPanelContext(@NotNull String location) {
        HashMap webPanelContext = this.buildWebPanelContext(location);
        return webPanelContext != null ? webPanelContext : new HashMap();
    }

    @Nullable
    public ElasticConfiguration getElasticConfig() {
        ElasticConfiguration existingElasticConfig;
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null && (existingElasticConfig = administrationConfiguration.getElasticConfig()) != null) {
            return existingElasticConfig;
        }
        return null;
    }

    public boolean isEc2ConfigurationWarningRequired() {
        return this.featureManager.isRequiredEc2Configuration();
    }

    @NotNull
    protected Map<String, Object> buildWebPanelContext(@NotNull String location) {
        return new LinkedHashMap<String, Object>();
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }

    public boolean isInlineDialog() {
        return "rest".equals(this.decorator);
    }

    public Set<String> getFieldErrorAccessTracker() {
        return this.fieldErrorAccessTracker;
    }

    public String toJson(Object object) {
        JsonElement convert = this.jsonator.convert(object);
        return convert.toString();
    }

    public String toJson(Object object, Jsonator.EnumConversionMode enumConversionMode) {
        JsonElement convert = this.jsonator.convert(object, enumConversionMode);
        return convert.toString();
    }

    public String getAvailableCategoryJson() throws JSONException {
        return this.toJson(TaskCategory.values(), Jsonator.EnumConversionMode.BEAN);
    }

    public void addHelpPanel(String helpPanel) {
        this.helpPanels.add(helpPanel);
    }

    public final List<Map<String, Object>> getHelpPanels() {
        return this.helpPanels.stream().map(this::createHelpPanelMap).collect(Collectors.toCollection(ArrayList::new));
    }

    private Map<String, Object> createHelpPanelMap(String helpPanel) {
        LinkedHashMap<String, Object> helpPanelMap = new LinkedHashMap<String, Object>();
        String titleKey = helpPanel + ".title";
        String contentKey = helpPanel + ".content";
        String typeKey = helpPanel + ".type";
        String linkKey = helpPanel;
        String typeStr = this.getText(typeKey);
        String linkStr = this.getText(linkKey);
        helpPanelMap.put("title", this.getText(titleKey));
        helpPanelMap.put("content", this.getText(contentKey));
        if (typeStr != null && !Objects.equals(typeStr, typeKey)) {
            helpPanelMap.put("type", typeStr);
        }
        if (linkStr != null && !Objects.equals(linkStr, linkKey)) {
            if (linkStr.startsWith("http")) {
                helpPanelMap.put("link", linkStr);
            } else {
                helpPanelMap.put("link", this.documentationLinkProvider.getUrl(linkKey));
            }
        }
        return helpPanelMap;
    }

    @Deprecated
    public String doExecute() throws Exception {
        return "success";
    }

    @Deprecated
    public String doInput() throws Exception {
        return "input";
    }

    public void setDocumentationLinkProvider(DocumentationLinkProvider documentationLinkProvider) {
        this.documentationLinkProvider = documentationLinkProvider;
    }

    @Inject
    public void setLocalizedTextProvider(LocalizedTextProvider localizedTextProvider) {
        this.localizedTextProvider = localizedTextProvider;
    }

    public static enum JSONStatus {
        OK,
        ERROR;

    }
}

