/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webwork.util;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionParametersMapImpl
extends SimpleActionParametersMap {
    private static final Logger log = Logger.getLogger(ActionParametersMapImpl.class);
    private final Map<String, File> uploadedFiles = new HashMap<String, File>();

    public ActionParametersMapImpl(ActionContext actionContext) {
        super(actionContext.getParameters());
    }

    public ActionParametersMapImpl(Map<String, ?> parameters) {
        super(parameters);
    }

    public ActionParametersMapImpl(ActionContext actionContext, boolean handleMultipartFiles) {
        this(actionContext);
        MultiPartRequestWrapper requestWrapper;
        Object request;
        if (handleMultipartFiles && (request = actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest")) instanceof ServletRequest && (requestWrapper = this.findFilesInRequest((ServletRequest)request)) != null) {
            Enumeration fieldNames = requestWrapper.getFileParameterNames();
            while (fieldNames.hasMoreElements()) {
                String fieldName = (String)fieldNames.nextElement();
                Object[] fileNames = requestWrapper.getFiles(fieldName);
                if (ArrayUtils.isEmpty((Object[])fileNames)) continue;
                this.uploadedFiles.put(fieldName, new File(fileNames[0].getAbsolutePath()));
            }
        }
    }

    @Nullable
    private MultiPartRequestWrapper findFilesInRequest(ServletRequest request) {
        MultiPartRequestWrapper result = null;
        if (request instanceof MultiPartRequestWrapper) {
            MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)request;
            Enumeration fieldNames = wrapper.getFileParameterNames();
            if (fieldNames.hasMoreElements()) {
                return wrapper;
            }
            result = this.findFilesInRequest(wrapper.getRequest());
        } else if (request instanceof HttpServletRequestWrapper) {
            result = this.findFilesInRequest(((ServletRequestWrapper)request).getRequest());
        }
        return result;
    }

    @NotNull
    public Map<String, File> getFiles() {
        return this.uploadedFiles;
    }

    public void recreateCheckboxValues() {
        Arrays.stream(ActionParamHandlingUtils.getCheckboxFields((ActionParametersMap)this)).forEach(checkboxField -> this.putIfAbsent(checkboxField, false));
    }
}

