/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webwork;

import com.atlassian.bamboo.ServerLifecycleProvider;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.webwork.StarterAction;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTelemetryAction
extends StarterAction {
    private static final Logger log = Logger.getLogger(ViewTelemetryAction.class);
    private String filter;
    private String projectKey;
    private String planKey;
    private boolean hideSuccessful;
    private ProjectManager projectManager;
    private ServerLifecycleProvider serverLifecycleProvider;
    private static final String FAVOURITES_FILTER = "favourites";
    private static final String PROJECT_FILTER = "project";
    private static final String LABEL_FILTER = "labels";
    private static final String DASHBOARD_FILTER = "dashboard";
    private static final String PLAN_AND_BRANCHES_FILTER = "showPlanAndBranches";

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    private boolean filterBySuccessState(ImmutableChain plan) {
        if (this.hideSuccessful) {
            ImmutableResultsSummary latestResultsSummary = plan.getLatestResultsSummary();
            if (latestResultsSummary != null) {
                return !latestResultsSummary.isSuccessful();
            }
            return true;
        }
        return true;
    }

    public Collection<? extends ImmutableChain> getFilteredBuilds() {
        Iterable<Object> plansForTelemetry = Collections.emptyList();
        if (FAVOURITES_FILTER.equals(this.getFilter())) {
            plansForTelemetry = this.getFavouriteBuilds();
        } else if (PROJECT_FILTER.equals(this.getFilter())) {
            Project project = this.projectManager.getProjectByKey(this.projectKey);
            if (project != null) {
                plansForTelemetry = this.planManager.getPlansByProject(project, TopLevelPlan.class);
            }
        } else {
            if (PLAN_AND_BRANCHES_FILTER.equals(this.getFilter())) {
                return this.getPlanActiveBuilds();
            }
            plansForTelemetry = LABEL_FILTER.equals(this.getFilter()) || DASHBOARD_FILTER.equals(this.getFilter()) ? this.getPlansByDashboardFilter() : this.getPlans();
        }
        plansForTelemetry = BambooIterables.stream(plansForTelemetry).filter(plan -> !plan.isSuspendedFromBuilding()).filter(this::filterBySuccessState).collect(Collectors.toList());
        return this.getSortedBuildSet(plansForTelemetry);
    }

    @NotNull
    public Iterable<? extends ImmutableChain> getPlansByDashboardFilter() {
        List plansByProjects = this.cachedPlanManager.getPlans(ImmutableChain.class, this.isInOneOfProjects(this.getFilteredProjectKeys()));
        ArrayList plans = new ArrayList(plansByProjects);
        List chainsAndBranchesWithLabel = this.cachedPlanManager.getPlans(ImmutableChain.class, this.hasOneOfLabels(this.getLabelNames()));
        plans.removeAll(chainsAndBranchesWithLabel);
        plans.addAll(chainsAndBranchesWithLabel);
        return plans;
    }

    private Predicate<? super ImmutablePlan> isInOneOfProjects(@Nullable List<String> projectKeys) {
        if (CollectionUtils.isEmpty(projectKeys)) {
            return Predicates.alwaysFalse();
        }
        assert (projectKeys != null);
        return chain -> projectKeys.contains(chain.getProject().getKey());
    }

    private Predicate<? super ImmutablePlan> hasOneOfLabels(@Nullable List<String> labelNames) {
        if (CollectionUtils.isEmpty(labelNames)) {
            return Predicates.alwaysFalse();
        }
        return plan -> plan.getLabelNames().stream().anyMatch(labelNames::contains);
    }

    @NotNull
    private List<ImmutableChain> getPlanActiveBuilds() {
        PlanKey key = PlanKeys.getPlanKey((String)this.planKey);
        TopLevelPlan plan = (TopLevelPlan)this.planManager.getPlanByKeyIfOfType(key, TopLevelPlan.class);
        if (plan != null) {
            List<ImmutableChain> sortedPlanBranches = this.getSortedBuildSet(Iterables.filter((Iterable)this.chainBranchManager.getBranchesForChain((ImmutableChain)plan), branch -> !branch.isSuspendedFromBuilding()));
            sortedPlanBranches.add(0, (ImmutableChain)plan);
            return sortedPlanBranches;
        }
        return Collections.emptyList();
    }

    private <T extends ImmutableChain> List<T> getSortedBuildSet(Iterable<T> builds) {
        return Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering().sortedCopy(builds);
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isHideSuccessful() {
        return this.hideSuccessful;
    }

    public void setHideSuccessful(boolean hideSuccessful) {
        this.hideSuccessful = hideSuccessful;
    }

    @Override
    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    @NotNull
    public ServerLifecycleState getServerLifecycleState() {
        return this.serverLifecycleProvider.getServerLifecycleState();
    }

    @Override
    public void setServerLifecycleProvider(ServerLifecycleProvider serverLifecycleProvider) {
        this.serverLifecycleProvider = serverLifecycleProvider;
    }
}

