/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webwork;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.author.collector.AuthorBuildsTriggeredCollector;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.charts.author.AuthorNumberBuildsBarChart;
import com.atlassian.bamboo.commit.CommitView;
import com.atlassian.bamboo.commit.UnassociatedCommit;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.dashboard.DashboardViewedEvent;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.ProjectStatusHelper;
import com.atlassian.bamboo.project.ProjectStatusHelperImpl;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterManager;
import com.atlassian.bamboo.quickfilter.UserActiveQuickFilterService;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.TabSelectionAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.acls.Permission;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.joda.time.DateTime;

public class StarterAction
extends BambooActionSupport
implements TabSelectionAware {
    private static final String DASHBOARD_TAB_COOKIE = "atlassian.bamboo.dashboard.tab.selected";
    private static final String DEFAULT_DASHBOARD_URL = "/allPlans.action";
    private static final String DASHBOARD_TABS_LOCATION = "system.dashboard";
    private static final String RESULT_WELCOME = "welcome";
    private static final String ALL_PLANS_TAB = "allPlansTab";
    private static final String MY_TAB = "myTab";
    private Long specsRepositoryId;
    private String buildProjectKey;
    private ExtendedAuthor author;
    private List<ExtendedAuthor> authors;
    private List<ImmutableTopLevelPlan> plans;
    private List<ImmutableChain> chains;
    private List<ImmutableChain> favouriteBuilds;
    private String reorderedBuildKey;
    private String selectedTab;
    private List<String> labelNames;
    private List<String> filteredProjectKeys;
    private List<CommitView> commitViews;
    private Map<String, Object> authorActivityChart;
    private Set<Long> plansWithBranches;
    private String lastProject;
    private int pageSize;
    private DashboardPage page;
    private final Supplier<Set<Long>> visibleQuickFilterIds = Suppliers.memoize(this::fetchVisibleQuickFilterIds);
    private final Supplier<Set<Long>> activeQuickFilterIds = Suppliers.memoize(this::fetchActiveQuickFilterIds);
    private AgentManager agentManager;
    protected ExtendedAuthorManager extendedAuthorManager;
    private ProjectStatusHelper projectStatusHelper;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private ResultsSummaryManager resultsSummaryManager;
    protected final BambooCachingPermissionManagerFacade cachingPermissionManagerFacade = (BambooCachingPermissionManagerFacade)ComponentAccessor.PROTOTYPE_CACHING_PERMISSION_MANAGER_FACADE.get();
    private VcsRepositoryManager vcsRepositoryManager;
    private BuildQueueManager buildQueueManager;
    private BuildExecutionManager buildExecutionManager;
    protected LabelManager labelManager;
    protected ChainBranchManager chainBranchManager;
    private EventPublisher eventPublisher;
    protected QuickFilterManager quickFilterManager;
    private UserActiveQuickFilterService userActiveQuickFilterService;

    public String start() {
        this.cookieCutter.getValueFromConglomerateCookie("AJS.conglomerate.cookie", "ASDQWE");
        if (this.getPlans().isEmpty() && !this.showOnlyFavoritesBuilds()) {
            return RESULT_WELCOME;
        }
        this.eventPublisher.publish((Object)new DashboardViewedEvent());
        return "success";
    }

    public String myBamboo() {
        this.cookieCutter.getValueFromConglomerateCookie("AJS.conglomerate.cookie", "ASDQWE");
        if (this.getPlans().isEmpty() && !this.showOnlyFavoritesBuilds()) {
            return RESULT_WELCOME;
        }
        return "success";
    }

    @Override
    public boolean hasPlanPermission(String permission, PlanIdentifier plan) {
        return this.cachingPermissionManagerFacade.hasPermission(BambooPermission.buildFromName((String)permission), (Object)plan);
    }

    public String getDashboardTabUrl() {
        if (this.selectedTab == null) {
            this.selectedTab = this.getCookieCutter().getValueFromCookie(DASHBOARD_TAB_COOKIE, ALL_PLANS_TAB);
        }
        if (this.getUser() == null && this.selectedTab.equals(MY_TAB)) {
            this.selectedTab = ALL_PLANS_TAB;
        }
        if (StringUtils.isNotBlank((CharSequence)this.selectedTab)) {
            HttpServletRequest request = ServletActionContext.getRequest();
            for (WebSectionModuleDescriptor section : this.getWebSectionsForLocation(DASHBOARD_TABS_LOCATION)) {
                for (WebItemModuleDescriptor item : this.getWebItemsForSection("system.dashboard/" + section.getKey())) {
                    if (!this.selectedTab.equals(item.getName())) continue;
                    return item.getLink().getRenderedUrl(this.getWebFragmentsContextMap());
                }
            }
        }
        return DEFAULT_DASHBOARD_URL;
    }

    public CurrentlyBuilding getCurrentlyBuilding(Long agentId) {
        return this.buildExecutionManager.getBuildRunningOnAgent(agentId);
    }

    public CurrentlyBuilding getCurrentlyBuilding(String buildResultKey) {
        return this.buildExecutionManager.getCurrentlyBuildingByBuildResultKey(buildResultKey);
    }

    public Collection<BuildAgent> getBuildAgents() {
        return this.agentManager.getActiveAndEnabledAgents();
    }

    public Collection<BuildAgent> getBusyBuildAgents() {
        return this.agentManager.getBusyBuildAgents();
    }

    public Collection<BuildQueueManager.QueuedResultKey> getQueue() {
        return ImmutableList.copyOf((Iterable)this.buildQueueManager.getQueuedExecutables());
    }

    public boolean isFavourite(ImmutableChain plan) {
        return this.getFavouriteBuilds().contains(plan);
    }

    @NotNull
    public List<ImmutableTopLevelPlan> getPlans() {
        if (this.plans == null) {
            if (this.showOnlyFavoritesBuilds()) {
                User user = this.getUser();
                this.plans = this.planManager.getFavouritePlansIds(user).stream().map(id -> (ImmutableTopLevelPlan)this.cachedPlanManager.getPlanByIdNotThrowing(id.longValue(), ImmutableTopLevelPlan.class)).filter(Objects::nonNull).filter(plan -> this.cachingPermissionManagerFacade.hasPermission((Permission)BambooPermission.READ, plan)).sorted((Comparator<ImmutableTopLevelPlan>)Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList());
            } else {
                this.plans = SystemProperty.DISABLE_MAIN_DASHBOARD_OPTIMIZATION.getTypedValue() ? this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class).stream().sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList()) : this.getPlansWithCheckProjectPermissionFirst(ImmutableTopLevelPlan.class);
            }
            this.cachingPermissionManagerFacade.primeAclCache(this.plans);
        }
        return this.plans;
    }

    public List<ImmutableChain> getChains() {
        if (this.chains == null) {
            this.chains = SystemProperty.DISABLE_MAIN_DASHBOARD_OPTIMIZATION.getTypedValue() ? this.cachedPlanManager.getPlans(ImmutableChain.class).stream().sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList()) : this.getPlansWithCheckProjectPermissionFirst(ImmutableChain.class);
        }
        return this.chains;
    }

    @NotNull
    public Collection<? extends ImmutableChain> getPlansByLabel() {
        return this.filterPlansByLabel(this.getPlans(), this.getLabelNames());
    }

    @NotNull
    public DashboardPage getPlansForDashboard() {
        if (this.page == null) {
            List plansForDashboard = Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering().sortedCopy(this.getBuildPlansForDashboard());
            this.page = this.getPageSize() > 0 ? this.getPageToNearestProject(this.lastProject, plansForDashboard, this.getPageSize()) : new DashboardPage(this.plans.size(), this.plans.size(), null, plansForDashboard, this.plans.size());
        }
        return this.page;
    }

    public boolean isDashboardFilterConfigured() {
        return CollectionUtils.isNotEmpty(this.getFilteredProjectKeys()) || CollectionUtils.isNotEmpty(this.getLabelNames());
    }

    @NotNull
    protected List<ImmutableTopLevelPlan> getBuildPlansForDashboard() {
        ArrayList<ImmutableTopLevelPlan> plansForDashboard = new ArrayList<ImmutableTopLevelPlan>();
        if (this.isDashboardFilterEnabled()) {
            if (this.showOnlyFavoritesBuilds()) {
                plansForDashboard.addAll(Lists.newArrayList((Iterable)Iterables.filter(this.getFavouriteBuilds(), ImmutableTopLevelPlan.class)));
            } else {
                List<ImmutableTopLevelPlan> plansByProjects = this.filterPlansByProject(this.getPlans(), this.getFilteredProjectKeys());
                List<ImmutableTopLevelPlan> chainsByLabel = this.filterPlansByLabel(this.getPlans(), this.getLabelNames());
                ArrayList topLevelPlansByLabel = Lists.newArrayList((Iterable)Iterables.filter(chainsByLabel, ImmutableTopLevelPlan.class));
                plansForDashboard.addAll(plansByProjects);
                plansForDashboard.removeAll(topLevelPlansByLabel);
                plansForDashboard.addAll(topLevelPlansByLabel);
            }
        } else {
            plansForDashboard.addAll(this.getPlans());
        }
        return plansForDashboard;
    }

    protected List<ImmutableTopLevelPlan> filterPlansByProject(List<ImmutableTopLevelPlan> plans, List<String> rawProjectKeys) {
        if (rawProjectKeys != null && !rawProjectKeys.isEmpty()) {
            final List projectKeys = Lists.transform(rawProjectKeys, StringUtils::upperCase);
            return Lists.newArrayList((Iterable)Iterables.filter(plans, (Predicate)new Predicate<ImmutableTopLevelPlan>(){

                public boolean apply(@Nullable ImmutableTopLevelPlan immutableTopLevelPlan) {
                    immutableTopLevelPlan = (ImmutableTopLevelPlan)Preconditions.checkNotNull((Object)immutableTopLevelPlan);
                    return projectKeys.contains(immutableTopLevelPlan.getProject().getKey());
                }
            }));
        }
        return Collections.emptyList();
    }

    @NotNull
    protected <T extends ImmutableChain> List<T> filterPlansByLabel(List<T> plans, List<String> theLabelNames) {
        if (CollectionUtils.isNotEmpty(theLabelNames)) {
            return plans.stream().filter(plan -> plan.getLabelNames().stream().anyMatch(theLabelNames::contains)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    protected DashboardPage getPageToNearestProject(@Nullable String lastProjectInPreviousPage, @NotNull List<ImmutableTopLevelPlan> plans, int pageSize) {
        ImmutableTopLevelPlan last;
        ArrayList<ImmutableTopLevelPlan> pageItems = new ArrayList<ImmutableTopLevelPlan>();
        int pageItemCount = 0;
        String lastProjectKey = null;
        boolean projectFromPreviousPageFound = StringUtils.isBlank((CharSequence)lastProjectInPreviousPage);
        for (ImmutableTopLevelPlan plan : plans) {
            if (plan.getProject().getKey().equals(lastProjectInPreviousPage)) {
                projectFromPreviousPageFound = true;
                continue;
            }
            if (!projectFromPreviousPageFound) continue;
            if (pageItemCount >= pageSize && !plan.getProject().getKey().equals(lastProjectKey)) break;
            pageItems.add(plan);
            lastProjectKey = plan.getProject().getKey();
            ++pageItemCount;
        }
        int accumulatedSubsetCount = (last = (ImmutableTopLevelPlan)Iterables.getLast(pageItems, null)) != null ? plans.indexOf(last) + 1 : 0;
        return new DashboardPage(accumulatedSubsetCount, plans.size(), lastProjectKey, pageItems, this.getPlans().size());
    }

    public List<CommitView> getCommitViews() {
        User user;
        if (this.commitViews == null && (user = this.getUser()) != null) {
            this.commitViews = new ArrayList<CommitView>();
            List uniqueCommits = this.resultsSummaryManager.getCommitsForUser(user.getName(), 10);
            for (UnassociatedCommit commit : uniqueCommits) {
                String changeSetId = commit.getChangeSetId();
                if (changeSetId == null) continue;
                List resultSummariesForCommit = this.resultsSummaryManager.getResultSummariesByChangeSetIdAndRepository(commit.getRepositoryId(), commit.getChangeSetId(), ChainResultsSummary.class);
                this.commitViews.add(new CommitView(commit, resultSummariesForCommit));
            }
        }
        return this.commitViews;
    }

    public ProjectStatusHelper getProjectStatusHelper() {
        if (this.projectStatusHelper == null) {
            this.projectStatusHelper = new ProjectStatusHelperImpl(this.getPlans(), (TextProvider)this);
        }
        return this.projectStatusHelper;
    }

    public boolean hasBranches(PlanIdentifier plan) {
        if (this.plansWithBranches == null) {
            this.plansWithBranches = this.chainBranchManager.getPlansWithBranches();
        }
        return this.plansWithBranches.contains(plan.getId());
    }

    public Collection<ImmutableChain> getFavouriteBuilds() {
        if (this.favouriteBuilds == null) {
            if (this.showOnlyFavoritesBuilds()) {
                this.favouriteBuilds = new ArrayList<ImmutableChain>();
                this.favouriteBuilds.addAll(this.getPlans());
            } else {
                User user = this.getUser();
                this.favouriteBuilds = user != null ? this.planManager.filterFavouritedPlans(this.getChains(), user).stream().sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList()) : Collections.emptyList();
            }
        }
        return this.favouriteBuilds;
    }

    public Map<String, Object> getChart() {
        List<ExtendedAuthor> authors = this.getAuthors();
        if (authors != null && !authors.isEmpty() && this.authorActivityChart == null) {
            int days = 60;
            HashMap<String, List<ResultsSummary>> resultsMap = new HashMap<String, List<ResultsSummary>>();
            List results = this.extendedAuthorManager.findRecentResultsTriggeredByAuthors(authors, days);
            if (!results.isEmpty()) {
                Collections.sort(results, Comparators.getBuildDateOrdering());
                resultsMap.put(authors.get(0).getName(), results);
                final DateTime todaysDate = new DateTime((Object)new Date());
                final DateTime startDate = todaysDate.minusDays(days);
                AuthorBuildsTriggeredCollector report = new AuthorBuildsTriggeredCollector(){

                    @Override
                    public String getPeriodRange() {
                        return "DAY";
                    }

                    @Override
                    protected RegularTimePeriod getFirstPeriod(Date earliestDataEntry, String periodRange) {
                        return this.getPeriod(startDate.toDate(), periodRange);
                    }

                    @Override
                    protected RegularTimePeriod getLastPeriod(Date latestDataEntry, String periodRange) {
                        return this.getPeriod(todaysDate.toDate(), periodRange);
                    }
                };
                report.setAuthorBuilds(resultsMap);
                TimeTableXYDataset dataSet = (TimeTableXYDataset)report.getDataSet();
                AuthorNumberBuildsBarChart bambooChart = new AuthorNumberBuildsBarChart(64, 160, "", "", "", (IntervalXYDataset)dataSet);
                this.authorActivityChart = bambooChart.generateChartParams();
            }
        }
        return this.authorActivityChart;
    }

    @Override
    @NotNull
    public String getSelectedTab() {
        return this.selectedTab;
    }

    @Override
    public void setSelectedTab(@NotNull String selectedTab) {
        this.selectedTab = selectedTab;
    }

    @Deprecated
    public ExtendedAuthor getAuthor() {
        List list;
        if (this.author == null && this.getUser() != null && (list = this.extendedAuthorManager.getLinkedAuthorForUser(this.getUser())) != null && !list.isEmpty()) {
            this.author = (ExtendedAuthor)list.get(0);
        }
        return this.author;
    }

    public List<ExtendedAuthor> getAuthors() {
        if (this.authors == null && this.getUser() != null) {
            this.authors = this.extendedAuthorManager.getLinkedAuthorForUser(this.getUser());
        }
        return this.authors;
    }

    public boolean isAllowedRemoteAgents() {
        return this.getBambooLicenseManager().getAllowedNumberOfRemoteAgents() > 0;
    }

    public SpecsOnboardingDialog getSpecsOnboarding() {
        return new SpecsOnboardingDialog(this.specsRepositoryId, this.buildProjectKey, this.administrationConfigurationAccessor, this.repositoryDefinitionManager, this.vcsRepositoryManager);
    }

    public void setSpecsRepositoryId(Long specsRepositoryId) {
        this.specsRepositoryId = specsRepositoryId;
    }

    public void setBuildProjectKey(String buildProjectKey) {
        this.buildProjectKey = buildProjectKey;
    }

    @Nullable
    public List<String> getLabelNames() {
        if (this.labelNames == null && this.getUser() != null) {
            User user = this.getUser();
            String preferenceForUser = this.getBambooUserManager().getPropertySet(user).getString("bamboo.dashboard.labels");
            this.labelNames = StringUtils.isNotEmpty((CharSequence)preferenceForUser) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)preferenceForUser)) : Collections.emptyList();
        }
        return this.labelNames;
    }

    public void setLabelNames(List<String> labelNames) {
        this.labelNames = labelNames;
    }

    @Nullable
    public List<String> getFilteredProjectKeys() {
        if (this.filteredProjectKeys == null && this.getUser() != null) {
            User user = this.getUser();
            String preferenceForUser = this.getBambooUserManager().getPropertySet(user).getString("bamboo.dashboard.projects");
            this.filteredProjectKeys = StringUtils.isNotEmpty((CharSequence)preferenceForUser) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)preferenceForUser)) : Collections.emptyList();
        }
        return this.filteredProjectKeys;
    }

    protected boolean showOnlyFavoritesBuilds() {
        if (this.getUser() != null) {
            User user = this.getUser();
            PropertySet propertySet = this.getBambooUserManager().getPropertySet(user);
            return propertySet.getBoolean("bamboo.dashboard.filter.enabled") && propertySet.getBoolean("bamboo.dashboard.show.only.favorites");
        }
        return false;
    }

    public boolean isDashboardFilterEnabled() {
        if (this.getUser() != null) {
            User user = this.getUser();
            return this.getBambooUserManager().getPropertySet(user).getBoolean("bamboo.dashboard.filter.enabled");
        }
        return false;
    }

    public void setFilteredProjectKeys(List<String> filteredProjectKeys) {
        this.filteredProjectKeys = filteredProjectKeys;
    }

    public List<QuickFilter> getConfiguredQuickFilters() {
        return this.quickFilterManager.findAll().stream().filter(quickFilter -> !quickFilter.getRules().isEmpty()).collect(Collectors.toList());
    }

    @NotNull
    public List<QuickFilter> getVisibleQuickFilters() {
        return this.getConfiguredQuickFilters().stream().filter(quickFilter -> ((Set)this.visibleQuickFilterIds.get()).contains(quickFilter.getId())).collect(Collectors.toList());
    }

    @NotNull
    private Set<Long> fetchVisibleQuickFilterIds() {
        User user = this.getUser();
        return user != null ? this.userActiveQuickFilterService.getVisibleQuickFilters(user).stream().map(BambooIdProvider::getId).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @NotNull
    private Set<Long> fetchActiveQuickFilterIds() {
        User user = this.getUser();
        return user != null ? this.userActiveQuickFilterService.getActiveQuickFilters(user).stream().map(BambooIdProvider::getId).collect(Collectors.toSet()) : Collections.emptySet();
    }

    protected <T extends ImmutableChain> List<T> getPlansWithCheckProjectPermissionFirst(Class<T> clazz) {
        Set allProjectsWithPlan = this.cachedPlanManager.getAllProjectsWithPlan();
        return this.cachedPlanManager.getPlans(clazz, p -> allProjectsWithPlan.contains(p.getProject())).stream().sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList());
    }

    public boolean isAnyQuickFilterActive() {
        return !((Set)this.activeQuickFilterIds.get()).isEmpty();
    }

    public boolean isQuickFilterActive(long quickFilterId) {
        return ((Set)this.activeQuickFilterIds.get()).contains(quickFilterId);
    }

    public void setLastProject(String lastProject) {
        this.lastProject = lastProject;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        if (this.pageSize <= 0) {
            AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
            this.pageSize = administrationConfiguration != null ? administrationConfiguration.getDashboardPageSize() : 50;
        }
        return this.pageSize;
    }

    public DashboardPage getPage() {
        return this.page;
    }

    public String getReorderedBuildKey() {
        return this.reorderedBuildKey;
    }

    public void setReorderedBuildKey(String reorderedBuildKey) {
        this.reorderedBuildKey = reorderedBuildKey;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.buildQueueManager = buildQueueManager;
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setQuickFilterManager(QuickFilterManager quickFilterManager) {
        this.quickFilterManager = quickFilterManager;
    }

    public void setUserActiveQuickFilterService(UserActiveQuickFilterService userActiveQuickFilterService) {
        this.userActiveQuickFilterService = userActiveQuickFilterService;
    }

    public static class SpecsOnboardingDialog {
        private final Long specsRepositoryId;
        private final String buildProjectKey;
        private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
        private final RepositoryDefinitionManager repositoryDefinitionManager;
        private final VcsRepositoryManager vcsRepositoryManager;

        public SpecsOnboardingDialog(@Nullable Long specsRepositoryId, @Nullable String buildProjectKey, @NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull VcsRepositoryManager vcsRepositoryManager) {
            this.specsRepositoryId = specsRepositoryId;
            this.administrationConfigurationAccessor = administrationConfigurationAccessor;
            this.repositoryDefinitionManager = repositoryDefinitionManager;
            this.vcsRepositoryManager = vcsRepositoryManager;
            this.buildProjectKey = buildProjectKey;
        }

        public boolean isVisible() {
            return this.specsRepositoryId != null;
        }

        public Long getSpecsRepositoryId() {
            return this.specsRepositoryId;
        }

        public boolean isSpecsWebhookRequired() {
            if (this.specsRepositoryId == null) {
                return false;
            }
            VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(this.specsRepositoryId.longValue());
            if (vcsRepositoryData == null) {
                return false;
            }
            VcsRepositoryModuleDescriptor vcsModuleDesc = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
            return vcsModuleDesc != null && vcsModuleDesc.getBambooSpecsHandler() != null && vcsModuleDesc.getBambooSpecsHandler().isWebhookRequired();
        }

        public boolean isShowSecuritySettingsHint() {
            return !this.administrationConfigurationAccessor.getAdministrationConfiguration().isUnauthenticatedRemoteTriggerAllowed();
        }

        @NotNull
        public String getBambooSpecsVersion() {
            return BambooSpecVersion.getModelVersion();
        }

        public String getBuildProjectKey() {
            return this.buildProjectKey;
        }
    }

    public class DashboardPage {
        private final int accumulatedSubsetCount;
        private final int totalSize;
        private final String lastProjectKey;
        private final List<ImmutableTopLevelPlan> items;
        private final int allVisiblePlans;

        public DashboardPage(int accumutatedSubsetCount, int totalSize, String lastProjectKey, List<ImmutableTopLevelPlan> items, int allVisiblePlans) {
            this.accumulatedSubsetCount = accumutatedSubsetCount;
            this.totalSize = totalSize;
            this.lastProjectKey = lastProjectKey;
            this.items = items;
            this.allVisiblePlans = allVisiblePlans;
        }

        public List<ImmutableTopLevelPlan> getItems() {
            return this.items;
        }

        public int getAccumulatedSubsetCount() {
            return this.accumulatedSubsetCount;
        }

        public int getNotIncludedCount() {
            return this.allVisiblePlans - this.totalSize;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public boolean isEmptyResults() {
            return this.totalSize == 0;
        }

        public boolean isShowMoreRequired() {
            return this.accumulatedSubsetCount < this.totalSize;
        }

        public boolean isMultiPage() {
            return this.totalSize > StarterAction.this.getPageSize();
        }

        public String getLastProjectKey() {
            return this.lastProjectKey;
        }
    }
}

