/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webwork;

import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterManager;
import com.atlassian.bamboo.webwork.StarterAction;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFilterAction
extends StarterAction {
    private List<Long> filterIds = Collections.emptyList();

    public void validate() {
        if (this.getUser() == null) {
            this.addActionError(this.getText("quick.filters.error.no.user"));
        }
        for (long filterId : this.filterIds) {
            if (this.quickFilterManager.findById(filterId) != null) continue;
            this.addActionError(this.getText("quick.filters.error.not.found", Collections.singletonList(String.valueOf(filterId))));
        }
    }

    @NotNull
    public String toggle() {
        return "success";
    }

    @Override
    @NotNull
    protected List<ImmutableTopLevelPlan> getBuildPlansForDashboard() {
        List<QuickFilter> quickFilters = this.getActiveQuickFilters();
        if (quickFilters.isEmpty()) {
            return this.getPlans();
        }
        Iterable<Object> plans = this.getPlans();
        for (QuickFilter quickFilter : quickFilters) {
            plans = this.quickFilterManager.filter(plans, quickFilter);
        }
        return ImmutableList.copyOf(plans);
    }

    @NotNull
    private List<QuickFilter> getActiveQuickFilters() {
        return this.filterIds.stream().map(arg_0 -> ((QuickFilterManager)this.quickFilterManager).findById(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean isAnyQuickFilterActive() {
        return !this.filterIds.isEmpty();
    }

    @Override
    public boolean isQuickFilterActive(long quickFilterId) {
        return this.filterIds.contains(quickFilterId);
    }

    @NotNull
    public List<Long> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(@Nullable Collection<Long> filterIds) {
        this.filterIds = ((Collection)ObjectUtils.defaultIfNull(filterIds, Collections.emptyList())).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

