/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webwork;

import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.webwork.StarterAction;
import com.atlassian.user.User;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DashboardFilter
extends StarterAction {
    public static final String BAMBOO_DASHBOARD_PROJECTS = "bamboo.dashboard.projects";
    public static final String BAMBOO_DASHBOARD_LABELS = "bamboo.dashboard.labels";
    public static final String BAMBOO_DASHBOARD_FILTER_ENABLED = "bamboo.dashboard.filter.enabled";
    public static final String BAMBOO_DASHBOARD_SHOW_ONLY_FAVORITES = "bamboo.dashboard.show.only.favorites";
    private List<String> selectedProjectKeys = new ArrayList<String>();
    private List<Project> selectedProjects = null;
    private boolean filterEnabled = false;
    private List<String> selectedLabelNames = new ArrayList<String>();
    private boolean showOnlyFavorites = false;

    @Override
    public String doDefault() {
        User user = this.getUser();
        if (user != null) {
            String preferenceForUser;
            this.filterEnabled = this.getBambooUserManager().getPropertySet(user).getBoolean(BAMBOO_DASHBOARD_FILTER_ENABLED);
            this.showOnlyFavorites = this.getBambooUserManager().getPropertySet(user).getBoolean(BAMBOO_DASHBOARD_SHOW_ONLY_FAVORITES);
            String projectKeysString = this.getBambooUserManager().getPropertySet(user).getString(BAMBOO_DASHBOARD_PROJECTS);
            if (projectKeysString != null) {
                this.selectedProjectKeys = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)projectKeysString));
            }
            this.selectedLabelNames = StringUtils.isNotEmpty((CharSequence)(preferenceForUser = this.getBambooUserManager().getPropertySet(user).getString(BAMBOO_DASHBOARD_LABELS))) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)preferenceForUser)) : Collections.emptyList();
            return "input";
        }
        this.addActionError("Could not edit dashboard filter.  Please log in");
        return "error";
    }

    public String toggle() {
        User user = this.getUser();
        if (user == null) {
            this.addActionError("Could not turn on dashboard filter.  Please log in");
            return "error";
        }
        this.getBambooUserManager().getPropertySet(user).setBoolean(BAMBOO_DASHBOARD_FILTER_ENABLED, this.filterEnabled);
        return "success";
    }

    public String execute() {
        String projectsAsString;
        PropertySet propertySet;
        User user = this.getUser();
        if (user != null) {
            propertySet = this.getBambooUserManager().getPropertySet(user);
            projectsAsString = this.selectedProjectKeys != null && !this.selectedProjectKeys.isEmpty() ? Joiner.on((String)",").join(this.selectedProjectKeys) : null;
            if (projectsAsString != null && projectsAsString.length() > 255) {
                this.addActionError("Character limit exceeded (" + projectsAsString.length() + "/" + 255 + " chars). Please deselect a few projects.");
                return "input";
            }
        } else {
            this.addActionError("Could not save dashboard filter.  Please log in");
            return "error";
        }
        propertySet.setString(BAMBOO_DASHBOARD_PROJECTS, projectsAsString);
        String labelsAsString = this.selectedLabelNames != null && !this.selectedLabelNames.isEmpty() ? Joiner.on((String)",").join(this.selectedLabelNames) : null;
        propertySet.setString(BAMBOO_DASHBOARD_LABELS, labelsAsString);
        propertySet.setBoolean(BAMBOO_DASHBOARD_FILTER_ENABLED, true);
        propertySet.setBoolean(BAMBOO_DASHBOARD_SHOW_ONLY_FAVORITES, this.showOnlyFavorites);
        return "success";
    }

    public List<Project> getExistingProjects() {
        if (this.selectedProjects == null) {
            this.selectedProjects = this.selectedProjectKeys.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.selectedProjects;
    }

    public JSONArray getExistingProjectsJson() throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Project project : this.getExistingProjects()) {
            jsonArray.put((Object)new JSONObject().put("id", (Object)project.getKey()).put("projectName", (Object)project.getName()));
        }
        return jsonArray;
    }

    public Iterable<Label> getAllPlanLabels() {
        return this.labelManager.getAllPlanLabels();
    }

    public List<String> getSelectedProjectKeys() {
        return this.selectedProjectKeys;
    }

    public void setSelectedProjectKeys(List<String> selectedProjectKeys) {
        this.selectedProjectKeys = selectedProjectKeys;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public List<String> getSelectedLabelNames() {
        return this.selectedLabelNames;
    }

    public void setSelectedLabelNames(List<String> labelNames) {
        this.selectedLabelNames = labelNames;
    }
}

