/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webhooks;

import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.exception.AccessDeniedException;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.webhook.WebhookResponseDetails;
import com.atlassian.bamboo.webhook.WebhookResponseService;
import com.atlassian.bamboo.webhook.WebhookResponseStatus;
import com.atlassian.bamboo.webhooks.WebhookResponseUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.struts.Preparable;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;

public class ViewWebhookResponseDetails
extends BambooActionSupport
implements Preparable {
    private Long webhookResponseId;
    private WebhookResponseDetails webhookResponseDetails;
    @Inject
    private WebhookResponseService webhookResponseService;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private DeploymentResultService deploymentResultService;
    @Inject
    private DeploymentProjectService deploymentProjectService;

    public Long getWebhookResponseId() {
        return this.webhookResponseId;
    }

    public void setWebhookResponseId(Long webhookResponseId) {
        this.webhookResponseId = webhookResponseId;
    }

    public void prepare() throws Exception {
        try {
            this.webhookResponseDetails = this.webhookResponseService.getWebhookResponseDetails(this.webhookResponseId);
        }
        catch (NoResultException ex) {
            this.webhookResponseDetails = null;
        }
    }

    public String input() throws Exception {
        if (this.webhookResponseDetails != null) {
            DeploymentResult deploymentResult;
            PlanResultKey planResultKey;
            if (StringUtils.isNotBlank((CharSequence)this.webhookResponseDetails.getPlanResultKey()) ? !this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, (planResultKey = PlanKeys.getPlanResultKey((String)this.webhookResponseDetails.getPlanResultKey())).getPlanKey()) : this.webhookResponseDetails.getDeploymentResultId() != null && !this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)this.deploymentProjectService.getDeploymentProjectForVersion((deploymentResult = this.deploymentResultService.getDeploymentResult(this.webhookResponseDetails.getDeploymentResultId().longValue())).getDeploymentVersion().getId()), null)) {
                throw new AccessDeniedException("Administration permission required");
            }
        } else {
            this.addActionError(String.format("Webhook response with id '%s' doesn't exist.", this.webhookResponseId));
            return "error";
        }
        return "input";
    }

    public WebhookResponseDetails getWebhookResponseDetails() {
        return this.webhookResponseDetails;
    }

    public void setWebhookResponseDetails(WebhookResponseDetails webhookResponseDetails) {
        this.webhookResponseDetails = webhookResponseDetails;
    }

    public WebhookResponseService getWebhookResponseService() {
        return this.webhookResponseService;
    }

    public void setWebhookResponseService(WebhookResponseService webhookResponseService) {
        this.webhookResponseService = webhookResponseService;
    }

    @Override
    public BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    @Override
    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public DeploymentResultService getDeploymentResultService() {
        return this.deploymentResultService;
    }

    public void setDeploymentResultService(DeploymentResultService deploymentResultService) {
        this.deploymentResultService = deploymentResultService;
    }

    public String codeColor(int statusCode) {
        return WebhookResponseUtils.codeColor(statusCode);
    }

    public String statusColor(WebhookResponseStatus status) {
        return WebhookResponseUtils.statusColor(status);
    }
}

