/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.ww2.build;

import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanExecuteSecurityAware;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TriggerManualBuild
extends ChainActionSupport
implements PlanExecuteSecurityAware {
    protected boolean dependenciesDisabled;
    protected Map<String, String> customVariables = new HashMap<String, String>();
    protected String customRevision;

    public void validate() {
        if (this.getImmutablePlan() == null) {
            this.addActionError("Could not trigger build, no plan with the key \"" + this.getBuildKey() + "\"could be found");
        }
    }

    public String execute() throws Exception {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(PlanKeys.getPlanKey((String)this.getPlanKey()), ImmutableChain.class);
        Map<String, String> params = this.calculateParams();
        ExecutionRequestResult result = this.planExecutionManager.startManualExecution(chain, this.getUser(), params, this.customVariables);
        PlanResultKey planResultKey = result.getPlanResultKey();
        return this.processResult(result, planResultKey);
    }

    @NotNull
    protected String processResult(ExecutionRequestResult result, PlanResultKey planResultKey) {
        if (planResultKey != null) {
            this.buildNumber = planResultKey.getBuildNumber();
            return "success";
        }
        this.addErrorCollection(result.getErrors());
        return "error";
    }

    public void setDependenciesDisabled(boolean dependenciesDisabled) {
        this.dependenciesDisabled = dependenciesDisabled;
    }

    public void setCustomRevision(String customRevision) {
        this.customRevision = customRevision;
    }

    public String getCustomRevision() {
        return this.customRevision;
    }

    protected Map<String, String> calculateParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.customRevision)) {
            params.put("customRevision", this.customRevision);
            params.put("dependenciesDisabled", Boolean.TRUE.toString());
        } else {
            params.put("dependenciesDisabled", Boolean.toString(this.dependenciesDisabled));
        }
        return params;
    }
}

