/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.ww2.build;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionConfigImpl;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.v2.ww2.build.TriggerManualBuild;
import com.atlassian.bamboo.variable.VariableComparators;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.aware.permissions.PlanExecuteSecurityAware;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ParameterisedManualBuild
extends TriggerManualBuild
implements PlanExecuteSecurityAware {
    private static final Logger log = Logger.getLogger(ParameterisedManualBuild.class);
    private static final String VARIABLE_PARAM_PREFIX = "variable_";
    private static final String OPTIONS_KEY = "options";
    private List<VariableDefinition> variables;
    private Collection<? extends VariableDefinitionContext> overridableVariables;
    private Map<String, VariableDefinitionContext> variableMap;
    private List<VariableDefinition> inheritedVariables;
    private String selectedStage;
    private String stageToContinue;
    private boolean branchMergePushOverride;
    private boolean verboseLogging;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private VariableDefinitionManager variableDefinitionManager;
    private ResultsSummaryVariableAccessor resultsSummaryVariableAccessor;

    @Override
    public String execute() throws Exception {
        if ("error".equals(this.parseAndValidateVariables())) {
            return "error";
        }
        if (!(this.isUserCanOverrideVariables() || this.customVariables.isEmpty() && this.customRevision == null)) {
            this.addActionError(this.getText("build.editParameterisedManualBuild.error.sox.user"));
            return "error";
        }
        Map<String, String> params = this.calculateParams();
        Object planExecutionConfig = StringUtils.isEmpty((CharSequence)this.selectedStage) ? new PlanExecutionConfigImpl(PlanExecutionConfig.PlanExecutionType.REGULAR) : new PlanExecutionConfigImpl(PlanExecutionConfig.PlanExecutionType.ENFORCE_MANUAL_AS_AUTOMATIC).setChain((ImmutableChain)this.getImmutablePlan()).setLatestManualStageForAutomaticExecution(this.selectedStage);
        if (this.branchMergePushOverride) {
            planExecutionConfig.setBranchMergePushOverride(this.branchMergePushOverride);
        }
        if (this.verboseLogging) {
            planExecutionConfig.setVerboseLogging(this.verboseLogging);
        }
        ExecutionRequestResult result = this.planExecutionManager.startManualExecution(this.getImmutableChain(), (PlanExecutionConfig)planExecutionConfig, this.getUser(), params, this.customVariables);
        PlanResultKey planResultKey = result.getPlanResultKey();
        return this.processResult(result, planResultKey);
    }

    private String parseAndValidateVariables() {
        ActionParametersMapImpl params = new ActionParametersMapImpl(ActionContext.getContext());
        for (String key : params.keySet()) {
            if (!key.startsWith(VARIABLE_PARAM_PREFIX)) continue;
            String variableKey = key.substring(VARIABLE_PARAM_PREFIX.length());
            String[] variableValues = params.getStringArray(key);
            if (variableValues != null && variableValues.length == 1) {
                VariableDefinitionContext originalVariable;
                String variableValue = params.getString(key);
                if (variableValue == null || (originalVariable = this.getVariableMap().get(variableKey)) != null && variableValue.equals(originalVariable.getValue())) continue;
                this.customVariables.put(variableKey, variableValue);
                continue;
            }
            this.addActionError(this.getText("build.editParameterisedManualBuild.error.variable.overridden.too.many.times", Collections.singletonList("variableKey")));
            return "error";
        }
        return "success";
    }

    public String continueBuild() throws Exception {
        ExecutionRequestResult result;
        PlanResultKey planResultKey;
        this.parseAndValidateVariables();
        if (!this.isUserCanOverrideVariables() && !this.customVariables.isEmpty()) {
            this.addActionError(this.getText("build.editParameterisedManualBuild.error.sox.user"));
            return "error";
        }
        PlanResultKey typedPlanResultKey = this.getTypedPlanResultKey();
        if (typedPlanResultKey == null) {
            throw new IllegalArgumentException("Plan result data not supplied");
        }
        ChainResultsSummary resultSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(typedPlanResultKey, ChainResultsSummary.class);
        if (resultSummary == null) {
            this.addActionError(this.getText("build.error.build.not.exists", Collections.singletonList(typedPlanResultKey)));
            return "error";
        }
        if (!this.isContinuable((ResultsSummary)resultSummary)) {
            this.addActionError(this.getText("build.error.could.not.continue.execution"));
            return "error";
        }
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(resultSummary.getPlanKey(), ImmutableChain.class);
        if (chain == null) {
            this.addActionError(this.getText("build.error.plan.not.exists", Collections.singletonList(resultSummary.getPlanKey())));
            return "error";
        }
        PlanExecutionConfig planExecutionConfig = new PlanExecutionConfigImpl(PlanExecutionConfig.PlanExecutionType.CONTINUE).setChainResultSummary(resultSummary).build();
        if (this.branchMergePushOverride) {
            planExecutionConfig.setBranchMergePushOverride(this.branchMergePushOverride);
        }
        if (this.verboseLogging) {
            planExecutionConfig.setVerboseLogging(this.verboseLogging);
        }
        if (!StringUtils.isEmpty((CharSequence)this.selectedStage)) {
            planExecutionConfig.setLatestManualStageForAutomaticExecution(this.selectedStage);
        }
        if ((planResultKey = (result = this.planExecutionManager.startManualExecution(chain, planExecutionConfig, this.getUser(), Collections.emptyMap(), this.customVariables)).getPlanResultKey()) != null) {
            this.buildNumber = planResultKey.getBuildNumber();
        }
        return "success";
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject result = super.buildJsonObject();
        result.put("redirectUrl", (Object)("/browse/" + this.getPlanKey() + "-" + this.getBuildNumber()));
        return result;
    }

    public boolean isShowPushOverrideOption() {
        BranchIntegrationConfiguration branchIntegrationConfiguration = this.getImmutableChain().getBuildDefinition().getBranchIntegrationConfiguration();
        return branchIntegrationConfiguration.isEnabled() && !branchIntegrationConfiguration.isPushEnabled();
    }

    private List<VariableDefinition> getVariables() {
        if (this.variables == null) {
            this.variables = this.getImmutablePlan().getEffectiveVariables();
        }
        return this.variables;
    }

    private List<VariableDefinition> getInheritedVariables() {
        if (this.inheritedVariables == null) {
            this.inheritedVariables = this.variableDefinitionManager.getInheritedNotOverriddenVariables((PlanIdentifier)this.getImmutablePlan());
        }
        return this.inheritedVariables;
    }

    @NotNull
    public Collection<? extends VariableDefinitionContext> getOverridableVariables() {
        if (this.overridableVariables == null) {
            Collection<VariableDefinitionContext> unmaskedOverridableVariables = this.getVariableMap().values();
            this.overridableVariables = VariableComparators.getVariableDefinitionContextOrdering().sortedCopy((Iterable)PasswordMaskingUtils.maskPasswordValues(unmaskedOverridableVariables, (Function)VariableDefinitionContextImpl.CLONE));
        }
        return this.overridableVariables;
    }

    public boolean isUserCanOverrideVariables() {
        return this.bambooPermissionManager.canRunCustomBuild(this.getImmutablePlan().getPlanKey());
    }

    public Map<String, VariableDefinitionContext> getOverriddenVariablesMap() {
        HashMap<String, VariableDefinitionContext> overriddenVarMap = new HashMap<String, VariableDefinitionContext>();
        ArrayList<? extends VariableDefinitionContext> overriddenVars = new ArrayList<VariableDefinitionContext>(this.getOverridableVariables());
        for (VariableDefinitionContext variableDefinitionContext : overriddenVars) {
            overriddenVarMap.put(variableDefinitionContext.getKey(), variableDefinitionContext);
        }
        return overriddenVarMap;
    }

    private Map<String, VariableDefinitionContext> getVariableMap() {
        if (this.variableMap == null) {
            if (this.getTypedPlanResultKey() != null) {
                this.variableMap = ImmutableMap.copyOf((Map)this.resultsSummaryVariableAccessor.calculateCurrentVariablesState(this.getTypedPlanResultKey()));
            } else {
                this.variableMap = new HashMap<String, VariableDefinitionContext>();
                for (VariableDefinition variable : Iterables.concat(this.getVariables(), this.getInheritedVariables())) {
                    this.variableMap.put(variable.getKey(), (VariableDefinitionContext)variable);
                }
            }
        }
        return this.variableMap;
    }

    public boolean planHasRepository() {
        return this.repositoryDefinitionManager.getRepositoryDefinitionsForPlan(this.getImmutablePlan()).size() > 0;
    }

    public boolean planHasManualStages() {
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)this.getImmutablePlan(), ImmutableChain.class);
        if (chain != null) {
            return chain.getStages().stream().anyMatch(ImmutableChainStage::isManual);
        }
        return false;
    }

    public ImmutableChainResultsSummary getResultSummary() {
        PlanResultKey resultKey = this.getTypedPlanResultKey();
        if (resultKey != null) {
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(resultKey);
            ImmutableChainResultsSummary chainResultSummary = (ImmutableChainResultsSummary)Narrow.to((Object)resultsSummary, ImmutableChainResultsSummary.class);
            if (chainResultSummary != null) {
                return chainResultSummary;
            }
            return null;
        }
        return null;
    }

    public boolean isContinuable() {
        ImmutableChainResultsSummary result = this.getResultSummary();
        return result != null && result.isContinuable();
    }

    public String getRunAction() {
        if (this.isContinuable()) {
            return "continueParametrisedBuild";
        }
        return "runParametrisedManualBuild";
    }

    public JSONObject getOverridableVariablesDropdownJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        LinkedHashMap<VariableType, JSONObject> optGroups = new LinkedHashMap<VariableType, JSONObject>();
        for (VariableDefinitionContext variableDefinitionContext : this.getOverridableVariables()) {
            VariableType variableType = variableDefinitionContext.getVariableType();
            JSONObject optGroup = (JSONObject)optGroups.get(variableType);
            if (optGroup == null) {
                JSONObject newOptGroup = new JSONObject();
                JSONArray newOptionsList = new JSONArray();
                newOptGroup.put("text", (Object)this.getText("variables.groupby." + variableType.toString().toLowerCase()));
                newOptGroup.put(OPTIONS_KEY, (Object)newOptionsList);
                optGroups.put(variableType, newOptGroup);
                optGroup = newOptGroup;
            }
            JSONArray optionList = (JSONArray)optGroup.get(OPTIONS_KEY);
            optionList.put((Object)this.makeDropdownOption(variableDefinitionContext));
        }
        return jsonObject.put(this.getVariablesKey(), optGroups.values());
    }

    private JSONObject makeDropdownOption(VariableDefinitionContext variableDefinition) throws JSONException {
        String value = variableDefinition.getValue();
        if (PasswordMaskingUtils.shouldBeMasked((String)variableDefinition.getKey())) {
            value = "********";
        }
        return new JSONObject().put("text", (Object)variableDefinition.getKey()).put("value", (Object)variableDefinition.getKey()).put("extraAttributes", (Object)new JSONObject().put("data-current-value", (Object)value));
    }

    @Override
    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setVariableDefinitionManager(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }

    public void setResultsSummaryVariableAccessor(ResultsSummaryVariableAccessor resultsSummaryVariableAccessor) {
        this.resultsSummaryVariableAccessor = resultsSummaryVariableAccessor;
    }

    public void setSelectedStage(String selectedStage) {
        this.selectedStage = selectedStage;
    }

    public String getSelectedStage() {
        return this.selectedStage;
    }

    public String getVariablesKey() {
        return "variables";
    }

    public String getStageToContinue() {
        return this.stageToContinue;
    }

    public void setStageToContinue(String stageToContinue) {
        this.stageToContinue = stageToContinue;
    }

    public boolean isBranchMergePushOverride() {
        return this.branchMergePushOverride;
    }

    public void setBranchMergePushOverride(boolean branchMergePushOverride) {
        this.branchMergePushOverride = branchMergePushOverride;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }
}

