/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.ww2.build;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionConfigImpl;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanExecuteSecurityAware;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractContinuableBuildAction
extends ChainActionSupport
implements PlanExecuteSecurityAware {
    public void validate() {
        ChainResultsSummary chainResultsSummary;
        ResultsSummary resultsSummary;
        if (this.getImmutablePlan() == null) {
            this.addActionError("Could not trigger build, no plan with the key \"" + this.getBuildKey() + "\"could be found");
        }
        if ((resultsSummary = this.getResultsSummaryManager().getResultsSummary(this.getTypedPlanResultKey())) == null) {
            this.addActionError("Could not trigger build, no result summary with the key \"" + this.getPlanResultKey() + "\"could be found");
        }
        if ((chainResultsSummary = (ChainResultsSummary)Narrow.to((Object)resultsSummary, ChainResultsSummary.class)) == null) {
            this.addActionError("Could not trigger build, result \"" + this.getPlanResultKey() + "\" does not support this action.");
        } else if (!this.checkResultSummary(chainResultsSummary)) {
            this.addActionError(this.getText("build.error.could.not.continue.execution"));
        }
    }

    public String execute() throws Exception {
        try {
            PlanResultKey typedPlanResultKey = this.getTypedPlanResultKey();
            if (typedPlanResultKey == null) {
                throw new IllegalArgumentException("Plan result data not supplied");
            }
            ChainResultsSummary resultSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(typedPlanResultKey, ChainResultsSummary.class);
            PlanExecutionConfig planExecutionConfig = new PlanExecutionConfigImpl(this.getPlanExecutionType()).setChainResultSummary(resultSummary).setChain(this.getImmutableChain()).setVerboseLogging(true).build();
            ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(resultSummary.getPlanKey(), ImmutableChain.class);
            if (chain == null) {
                this.addActionError("Chain " + resultSummary.getPlanKey() + " does not exist");
                return "error";
            }
            ExecutionRequestResult result = this.planExecutionManager.startManualExecution(chain, planExecutionConfig, this.getUser(), Collections.emptyMap(), Collections.emptyMap());
            PlanResultKey planResultKey = result.getPlanResultKey();
            if (planResultKey != null) {
                this.buildNumber = planResultKey.getBuildNumber();
                return "success";
            }
            this.addErrorCollection(result.getErrors());
            return "error";
        }
        catch (IllegalArgumentException ex) {
            this.addActionError(ex);
            return "error";
        }
    }

    protected abstract boolean checkResultSummary(@NotNull ChainResultsSummary var1);

    protected abstract PlanExecutionConfig.PlanExecutionType getPlanExecutionType();
}

