/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementSetRenderer {
    private static final Logger log = Logger.getLogger(RequirementSetRenderer.class);
    private TextProvider textProvider;
    private CapabilityHelper capabilityHelper;
    private Set<Requirement> requirements;

    public List<RequirementRenderer> getRequirements() {
        return new ArrayList<RequirementRenderer>();
    }

    public void setRequirements(Set<Requirement> requirements) {
        this.requirements = requirements;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setCapabilityHelper(CapabilityHelper capabilityHelper) {
        this.capabilityHelper = capabilityHelper;
    }

    private class RequirementRenderer {
        private final Requirement requirement;
        private final CapabilityType capabilityType;

        private RequirementRenderer(Requirement requirement) {
            if (requirement == null) {
                throw new IllegalArgumentException("Requirement must not be null");
            }
            this.requirement = requirement;
            this.capabilityType = RequirementSetRenderer.this.capabilityHelper.getCapabilityTypeFromKey(requirement.getKey());
        }

        public String getKey() {
            return this.requirement.getKey();
        }

        public String getValue() {
            return this.requirement.getMatchValue();
        }

        public String getTypeText() {
            return this.capabilityType.getCapabilityTypeKey();
        }

        public String getLabel() {
            return "";
        }

        public boolean isExists() {
            return true;
        }

        public boolean isEquals() {
            return true;
        }

        public boolean isSystemRequirement() {
            return true;
        }
    }
}

