/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.AbstractDecoratedCapabilityRequirement;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementAware;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.opensymphony.xwork2.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementDecorator
extends AbstractDecoratedCapabilityRequirement {
    private final String pluginModuleKey;
    private final ImmutableRequirement.MatchType matchType;
    @Nullable
    private final RequirementAware requirementAware;

    public RequirementDecorator(@NotNull ImmutableRequirement requirement, @NotNull CapabilityType capabilityType, @NotNull TextProvider textProvider, @NotNull CapabilityGroup capabilityGroup, @Nullable RequirementAware requirementAware) {
        super(textProvider, capabilityType, requirement.getKey(), requirement.getMatchValue(), capabilityGroup, requirement.getId(), requirement.isReadonly());
        this.requirementAware = requirementAware;
        this.pluginModuleKey = requirement.getPluginModuleKey();
        this.matchType = requirement.getTypeOfMatch();
    }

    public ImmutableRequirement.MatchType getTypeOfMatch() {
        return this.matchType;
    }

    public String getMatchType() {
        switch (this.matchType) {
            case EQUALS: {
                return "equal";
            }
            case EXISTS: {
                return "exist";
            }
            case MATCHES: {
                return "match";
            }
        }
        throw new IllegalStateException("unknown match type");
    }

    @Nullable
    public String getMatchValue() {
        if (this.matchType == ImmutableRequirement.MatchType.EXISTS) {
            return null;
        }
        return this.value;
    }

    @Nullable
    public RequirementAware getRequirementAware() {
        return this.requirementAware;
    }

    public String getPluginModuleKey() {
        return this.pluginModuleKey;
    }
}

