/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerforceCapabilityType
extends AbstractCapabilityType {
    public static final String P4_EXE = "p4Executable";
    public static final String P4_CAPABILITY_KEY = "system.p4Executable";

    public int getSortOrder() {
        return 300;
    }

    @NotNull
    public String getCapabilityTypeKey() {
        return "perforce";
    }

    @NotNull
    public String getCapabilityTypeLabel() {
        return "Perforce";
    }

    @NotNull
    public String getLabel(@NotNull String key) {
        return "Perforce Executable";
    }

    @Nullable
    public String getExtraInfo(@NotNull String key) {
        return null;
    }

    @Nullable
    public String getValueDescriptionKey(@NotNull String key, @Nullable String value) {
        return null;
    }

    public boolean isAllowRename() {
        return false;
    }

    @NotNull
    public String getNewKeyFromLabel(@NotNull String oldKey, @NotNull String label) {
        return P4_CAPABILITY_KEY;
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String p4exe = params.get(P4_EXE)[0];
        if (StringUtils.isEmpty((CharSequence)p4exe)) {
            fieldErrors.put(P4_EXE, "The p4 executable has not been defined");
        }
        return fieldErrors;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String p4path = params.get(P4_EXE)[0].trim();
        return new CapabilityImpl(P4_CAPABILITY_KEY, p4path, CapabilitySource.UI);
    }
}

