/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import com.google.common.base.Supplier;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkCapabilityType
extends AbstractCapabilityType {
    private static final Logger log = Logger.getLogger(JdkCapabilityType.class);
    private static final String FIELD_JDK_LABEL = "jdkLabel";
    private static final String FIELD_JDK_PATH = "jdkPath";
    private Supplier<TextProvider> textProvider = ComponentAccessor.TEXT_PROVIDER;

    public int getSortOrder() {
        return 200;
    }

    @NotNull
    public String getCapabilityTypeKey() {
        return "jdk";
    }

    @NotNull
    public String getCapabilityTypeLabel() {
        return "JDK";
    }

    @Nullable
    public String getViewTypeAction() {
        return "viewJdks";
    }

    @NotNull
    public String getLabel(@NotNull String key) {
        String[] strings = key.split("\\.", 3);
        if (strings.length == 3) {
            return strings[2];
        }
        log.warn((Object)("Key: '" + key + "' cannot be parsed. Returning full key"));
        return key;
    }

    @Nullable
    public String getExtraInfo(@NotNull String key) {
        return null;
    }

    @Nullable
    public String getValueDescriptionKey(@NotNull String key, @Nullable String value) {
        return null;
    }

    public boolean isAllowRename() {
        return true;
    }

    @NotNull
    public String getNewKeyFromLabel(@NotNull String oldKey, @NotNull String label) {
        return "system.jdk." + label;
    }

    public void updatePlanForNewLabel(@NotNull Buildable plan, @NotNull String oldLabel, @NotNull String newLabel) {
        this.updateTasksForNewLabel(plan, "buildJdk", oldLabel, newLabel);
    }

    public String getCapabilityTypeSpecificTaskConfigurationKey() {
        return "buildJdk";
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String jdkLabel = params.get(FIELD_JDK_LABEL)[0];
        String jdkPath = params.get(FIELD_JDK_PATH)[0];
        if (StringUtils.isBlank((CharSequence)jdkLabel)) {
            fieldErrors.put(FIELD_JDK_LABEL, ((TextProvider)this.textProvider.get()).getText("agent.capability.type.jdk.error.empty.label"));
        } else {
            BambooFieldValidate.checkFieldXssSafety(fieldErrors, (TextProvider)((TextProvider)this.textProvider.get()), (String)FIELD_JDK_LABEL, (String)jdkLabel);
        }
        if (StringUtils.isBlank((CharSequence)jdkPath)) {
            fieldErrors.put(FIELD_JDK_PATH, ((TextProvider)this.textProvider.get()).getText("agent.capability.type.jdk.error.empty.path"));
        }
        return fieldErrors;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String jdkLabel = params.get(FIELD_JDK_LABEL)[0].trim();
        String jdkPath = BambooFilenameUtils.stripTrailingSlashes((String)params.get(FIELD_JDK_PATH)[0].trim());
        return new CapabilityImpl("system.jdk." + jdkLabel, jdkPath, CapabilitySource.UI);
    }
}

