/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import com.google.common.base.Supplier;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericCapabilityType
extends AbstractCapabilityType {
    private static final String FIELD_CAPABILITY_KEY = "capabilityKey";
    private static final String FIELD_CAPABILITY_VALUE = "capabilityValue";
    private Supplier<TextProvider> textProvider = ComponentAccessor.TEXT_PROVIDER;

    public int getSortOrder() {
        return 0;
    }

    @NotNull
    public String getCapabilityTypeKey() {
        return "custom";
    }

    @NotNull
    public String getCapabilityTypeLabel() {
        return "Custom";
    }

    @NotNull
    public String getLabel(@NotNull String key) {
        return key;
    }

    @Nullable
    public String getExtraInfo(@NotNull String key) {
        return null;
    }

    @Nullable
    public String getValueDescriptionKey(@NotNull String key, @Nullable String value) {
        return null;
    }

    public boolean isAllowRename() {
        return true;
    }

    @NotNull
    public String getNewKeyFromLabel(@NotNull String oldKey, @NotNull String label) {
        return label;
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String capabilityKey = params.get(FIELD_CAPABILITY_KEY)[0];
        if (StringUtils.isBlank((CharSequence)capabilityKey)) {
            fieldErrors.put(FIELD_CAPABILITY_KEY, "You must specify a capability key.");
        } else {
            BambooFieldValidate.checkFieldXssSafety(fieldErrors, (TextProvider)((TextProvider)this.textProvider.get()), (String)FIELD_CAPABILITY_KEY, (String)capabilityKey);
        }
        return fieldErrors;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String capabilityKey = params.get(FIELD_CAPABILITY_KEY)[0].trim();
        String capabilityValue = params.get(FIELD_CAPABILITY_VALUE)[0].trim();
        return new CapabilityImpl(capabilityKey, capabilityValue, CapabilitySource.UI);
    }
}

