/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.DecoratedCapabilityRequirement;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementAwareMapping;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementDecoratorComparator;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityRequirementSetDecorator {
    private static final Logger log = Logger.getLogger(CapabilityRequirementSetDecorator.class);
    private final SortedMap<Integer, CapabilityGroup> capabilityGroupTreeMap;
    private Multimap<String, RequirementDecorator> taskGroupTreeMap;
    private Multimap<RequirementDecorator, String> requirementGroupTreeMap;
    private TaskManager taskManager;

    public CapabilityRequirementSetDecorator(@NotNull ReadOnlyCapabilitySet capabilitySet, @Nullable ReadOnlyCapabilitySet parentCapabilitySet, @NotNull com.atlassian.struts.TextProvider textProvider, @NotNull CapabilityHelper capabilityHelper) {
        this(capabilitySet.getCapabilities(), parentCapabilitySet, textProvider, capabilityHelper);
    }

    public CapabilityRequirementSetDecorator(@NotNull Collection<Capability> capabilities, @Nullable ReadOnlyCapabilitySet parentCapabilitySet, @NotNull com.atlassian.struts.TextProvider textProvider, @NotNull CapabilityHelper capabilityHelper) {
        this.capabilityGroupTreeMap = new TreeMap<Integer, CapabilityGroup>();
        for (Capability capability : capabilities) {
            CapabilityType capabilityType = capabilityHelper.getCapabilityTypeFromKey(capability.getKey());
            int sortOrder = capabilityType.getSortOrder();
            this.capabilityGroupTreeMap.computeIfAbsent(sortOrder, key -> new CapabilityGroup(capabilityType, (TextProvider)textProvider));
            CapabilityGroup capabilityGroup = (CapabilityGroup)this.capabilityGroupTreeMap.get(sortOrder);
            capabilityGroup.addCapability(capability, capabilityType, parentCapabilitySet);
        }
    }

    public CapabilityRequirementSetDecorator(@NotNull ImmutableBuildable buildable, @NotNull ImmutableRequirementSet requirementSet, @NotNull com.atlassian.struts.TextProvider textProvider, @NotNull CapabilityHelper capabilityHelper, @NotNull TaskManager taskManager) {
        this(buildable, buildable.getRequirementSet().getRequirements(), textProvider, capabilityHelper, taskManager);
    }

    public CapabilityRequirementSetDecorator(@NotNull Collection<? extends ImmutableRequirement> requirements, @NotNull com.atlassian.struts.TextProvider textProvider, @NotNull CapabilityHelper capabilityHelper) {
        this.capabilityGroupTreeMap = new TreeMap<Integer, CapabilityGroup>();
        for (ImmutableRequirement immutableRequirement : requirements) {
            CapabilityType capabilityType = capabilityHelper.getCapabilityTypeFromKey(immutableRequirement.getKey());
            int sortOrder = capabilityType.getSortOrder();
            this.capabilityGroupTreeMap.computeIfAbsent(sortOrder, key -> new CapabilityGroup(capabilityType, (TextProvider)textProvider));
            CapabilityGroup capabilityGroup = (CapabilityGroup)this.capabilityGroupTreeMap.get(sortOrder);
            capabilityGroup.addRequirement(immutableRequirement, capabilityType);
        }
    }

    public CapabilityRequirementSetDecorator(@NotNull ImmutableBuildable buildable, @NotNull Collection<? extends ImmutableRequirement> requirements, @NotNull com.atlassian.struts.TextProvider textProvider, @NotNull CapabilityHelper capabilityHelper, @NotNull TaskManager taskManager) {
        this.taskManager = taskManager;
        this.capabilityGroupTreeMap = new TreeMap<Integer, CapabilityGroup>();
        HashMap<Long, String> taskDescriptions = new HashMap<Long, String>();
        ArrayList<String> tasksOrder = new ArrayList<String>();
        tasksOrder.add("");
        taskDescriptions.put(-1L, this.getLabelForRequirementGroup(null));
        for (TaskDefinition taskDefinition : buildable.getBuildDefinition().getTaskDefinitions()) {
            String description = this.getLabelForRequirementGroup(taskDefinition);
            tasksOrder.add(description);
            taskDescriptions.put(taskDefinition.getId(), description);
        }
        this.taskGroupTreeMap = TreeMultimap.create((Comparator)Ordering.explicit(tasksOrder), (Comparator)new RequirementDecoratorComparator());
        this.requirementGroupTreeMap = TreeMultimap.create((Comparator)Ordering.usingToString(), (Comparator)Ordering.explicit(tasksOrder));
        for (ImmutableRequirement immutableRequirement : requirements) {
            CapabilityType capabilityType = capabilityHelper.getCapabilityTypeFromKey(immutableRequirement.getKey());
            int sortOrder = capabilityType.getSortOrder();
            this.capabilityGroupTreeMap.computeIfAbsent(sortOrder, key -> new CapabilityGroup(capabilityType, (TextProvider)textProvider));
            CapabilityGroup capabilityGroup = (CapabilityGroup)this.capabilityGroupTreeMap.get(sortOrder);
            RequirementDecorator requirementDecorator = capabilityGroup.addRequirement(immutableRequirement, capabilityType);
            this.taskGroupTreeMap.put(taskDescriptions.get(immutableRequirement.getOwnerId()), (Object)requirementDecorator);
            this.requirementGroupTreeMap.put((Object)requirementDecorator, taskDescriptions.get(immutableRequirement.getOwnerId()));
        }
    }

    public CapabilityRequirementSetDecorator(@NotNull List<? extends RequirementAwareMapping> requirementPlanMappings, @NotNull com.atlassian.struts.TextProvider textProvider, @NotNull CapabilityHelper capabilityHelper) {
        this.capabilityGroupTreeMap = new TreeMap<Integer, CapabilityGroup>();
        for (RequirementAwareMapping requirementAwareMapping : requirementPlanMappings) {
            Requirement requirement = requirementAwareMapping.getRequirement();
            CapabilityType capabilityType = capabilityHelper.getCapabilityTypeFromKey(requirement.getKey());
            int sortOrder = capabilityType.getSortOrder();
            this.capabilityGroupTreeMap.computeIfAbsent(sortOrder, key -> new CapabilityGroup(capabilityType, (TextProvider)textProvider));
            CapabilityGroup capabilityGroup = (CapabilityGroup)this.capabilityGroupTreeMap.get(sortOrder);
            capabilityGroup.addRequirement((ImmutableRequirement)requirement, capabilityType, requirementAwareMapping.getRequirementAware());
        }
    }

    public Collection<CapabilityGroup> getGroups() {
        return this.capabilityGroupTreeMap.values();
    }

    @NotNull
    public List<DecoratedCapabilityRequirement> getDecoratedObjects() {
        ArrayList<DecoratedCapabilityRequirement> decoratedObjects = new ArrayList<DecoratedCapabilityRequirement>();
        for (CapabilityGroup capabilityGroup : this.getGroups()) {
            List<DecoratedCapabilityRequirement> decoratedCapabilityRequirements = capabilityGroup.getDecoratedObjects();
            if (decoratedCapabilityRequirements == null) continue;
            decoratedObjects.addAll(decoratedCapabilityRequirements);
        }
        return decoratedObjects;
    }

    public Multimap<String, RequirementDecorator> getDecoratedObjectsByTask() {
        return this.taskGroupTreeMap;
    }

    public Multimap<RequirementDecorator, String> getDecoratedObjectsByRequirement() {
        return this.requirementGroupTreeMap;
    }

    private String getLabelForRequirementGroup(TaskDefinition taskDefinition) {
        if (taskDefinition == null) {
            return "";
        }
        String taskName = "";
        if (StringUtils.isBlank((CharSequence)taskDefinition.getUserDescription())) {
            TaskModuleDescriptor taskDescriptor;
            if (this.taskManager != null && (taskDescriptor = this.taskManager.getTaskDescriptor(taskDefinition.getPluginKey())) != null) {
                taskName = taskDescriptor.getName();
            }
        } else {
            taskName = taskDefinition.getUserDescription();
        }
        return Long.toString(taskDefinition.getId()) + " - " + taskName;
    }

    public String getPrettyLabel(String label) {
        return StringUtils.substringAfter((String)label, (String)"-").trim();
    }

    public String getTaskNumber(String label) {
        return StringUtils.substringBefore((String)label, (String)"-").trim();
    }
}

