/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.AgentEnvironmentCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.BuilderCapabilityDescriptor;
import com.atlassian.bamboo.v2.build.agent.capability.BuilderCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityTypeModule;
import com.atlassian.bamboo.v2.build.agent.capability.GenericCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.JdkCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.PerforceCapabilityType;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityHelperImpl
implements CapabilityHelper {
    private final PluginAccessor pluginAccessor;
    protected final Map<String, CapabilityType> builtinCapabilityTypes = new HashMap<String, CapabilityType>();
    private final Set<CapabilityType> nonSelectableCapabilityTypes = new HashSet<CapabilityType>();
    private final BuilderCapabilityType builderCapabilityType;
    private final JdkCapabilityType jdkCapabilityType;
    private final GenericCapabilityType genericCapabilityType;
    private final PerforceCapabilityType perforceCapabilityType;
    private final AgentEnvironmentCapabilityType agentEnvironmentCapabilityType;

    public CapabilityHelperImpl(PluginAccessor pluginAccessor) {
        CapabilityType[] ct;
        this.pluginAccessor = pluginAccessor;
        this.builderCapabilityType = new BuilderCapabilityType();
        this.jdkCapabilityType = new JdkCapabilityType();
        this.genericCapabilityType = new GenericCapabilityType();
        this.perforceCapabilityType = new PerforceCapabilityType();
        this.agentEnvironmentCapabilityType = new AgentEnvironmentCapabilityType();
        for (CapabilityType capabilityType : ct = new CapabilityType[]{this.builderCapabilityType, this.jdkCapabilityType, this.genericCapabilityType, this.perforceCapabilityType, this.agentEnvironmentCapabilityType}) {
            this.builtinCapabilityTypes.put(capabilityType.getCapabilityTypeKey(), capabilityType);
        }
        this.nonSelectableCapabilityTypes.add((CapabilityType)this.agentEnvironmentCapabilityType);
    }

    @NotNull
    public JSONObject buildCapabilityJsonObject(@NotNull Capability capability) throws JSONException {
        CapabilityType capabilityType = this.getCapabilityTypeFromKey(capability.getKey());
        JSONObject result = new JSONObject();
        result.put("key", (Object)capability.getKey());
        result.put("value", (Object)capability.getValueWithDefault());
        result.put("label", (Object)capabilityType.getLabel(capability.getKey()));
        return result;
    }

    @Nullable
    public CapabilityType getCapabilityTypeFromTypeString(String capabilityTypeKey) {
        CapabilityType builtinType = this.builtinCapabilityTypes.get(capabilityTypeKey);
        return builtinType != null ? builtinType : this.getCapabilityTypeModule(capabilityTypeKey);
    }

    public Collection<BuilderCapabilityDescriptor> getFilteredBuildersFromTypeString(String capabilityTypeKey, String capabilityPrefix) {
        BuilderCapabilityType capabilityType = (BuilderCapabilityType)((Object)Narrow.to((Object)this.getCapabilityTypeFromTypeString(capabilityTypeKey), BuilderCapabilityType.class));
        if (capabilityType != null) {
            return capabilityType.getBuilderTypes().stream().filter(input -> StringUtils.isBlank((CharSequence)capabilityPrefix) || input.getKey().equalsIgnoreCase(capabilityPrefix)).collect(Collectors.toList());
        }
        return new ArrayList<BuilderCapabilityDescriptor>();
    }

    @NotNull
    public CapabilityType getCapabilityTypeFromKey(String key) {
        CapabilityType type = this.getCapabilityTypeFromTypeString(this.getCapabilityType(key));
        return type != null ? type : this.genericCapabilityType;
    }

    public String getCapabilityType(String key) {
        if (!StringUtils.isBlank((CharSequence)key)) {
            if (key.startsWith("system.builder")) {
                return this.builderCapabilityType.getCapabilityTypeKey();
            }
            if (key.startsWith("system.jdk")) {
                return this.jdkCapabilityType.getCapabilityTypeKey();
            }
            if (key.startsWith("system.p4Executable")) {
                return this.perforceCapabilityType.getCapabilityTypeKey();
            }
            if (key.startsWith("system.agent.environment")) {
                return this.agentEnvironmentCapabilityType.getCapabilityTypeKey();
            }
            CapabilityType pluginCapabilityType = this.getCapabilityTypeModule(key);
            if (pluginCapabilityType != null) {
                return pluginCapabilityType.getCapabilityTypeKey();
            }
        }
        return this.genericCapabilityType.getCapabilityTypeKey();
    }

    @Nullable
    private CapabilityType getCapabilityTypeModule(String capabilityTypeKey) {
        List pluginCapabilityTypes = this.pluginAccessor.getEnabledModulesByClass(CapabilityTypeModule.class);
        for (CapabilityType capabilityType : pluginCapabilityTypes) {
            if (!capabilityTypeKey.startsWith(capabilityType.getCapabilityTypeKey())) continue;
            return capabilityType;
        }
        return null;
    }

    @NotNull
    public String getCapabilityLabel(String key) {
        CapabilityType type = this.getCapabilityTypeFromKey(key);
        return type.getLabel(key);
    }

    @Nullable
    public String getCapabilityExtraInfo(String key) {
        CapabilityType type = this.getCapabilityTypeFromKey(key);
        return type.getExtraInfo(key);
    }

    public String getCapabilityTabForKey(String key) {
        return key.replaceAll("[\\s.]", "_").replaceAll("[^A-Za-z0-9\\-_:]", "");
    }

    public List<CapabilityType> getCapabilityTypes() {
        ArrayList<CapabilityType> list = new ArrayList<CapabilityType>(this.builtinCapabilityTypes.values());
        list.removeAll(this.nonSelectableCapabilityTypes);
        list.addAll(this.pluginAccessor.getEnabledModulesByClass(CapabilityType.class));
        Collections.sort(list);
        return list;
    }
}

