/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.DecoratedCapabilityRequirement;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementAware;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementDecorator;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityGroup
implements Comparable<CapabilityGroup> {
    private final CapabilityType capabilityType;
    private final TextProvider textProvider;
    private final List<DecoratedCapabilityRequirement> capabilityDecorators = new ArrayList<DecoratedCapabilityRequirement>();

    public CapabilityGroup(CapabilityType capabilityType, TextProvider textProvider) {
        this.capabilityType = capabilityType;
        this.textProvider = textProvider;
    }

    public String getTypeKey() {
        return this.capabilityType.getCapabilityTypeKey();
    }

    public String getTypeLabel() {
        return this.textProvider.getText("agent.capability.type." + this.getTypeKey() + ".title");
    }

    public List<DecoratedCapabilityRequirement> getDecoratedObjects() {
        Collections.sort(this.capabilityDecorators);
        return this.capabilityDecorators;
    }

    public void addCapability(@NotNull Capability capability, @NotNull CapabilityType capabilityType, @Nullable ReadOnlyCapabilitySet parentCapabilitySet) {
        this.capabilityDecorators.add(new CapabilityDecorator(capability, capabilityType, parentCapabilitySet, this.textProvider, this));
    }

    public RequirementDecorator addRequirement(@NotNull ImmutableRequirement requirement, @NotNull CapabilityType capabilityType) {
        RequirementDecorator requirementDecorator = new RequirementDecorator(requirement, capabilityType, this.textProvider, this, null);
        this.capabilityDecorators.add(requirementDecorator);
        return requirementDecorator;
    }

    public void addRequirement(@NotNull ImmutableRequirement requirement, @NotNull CapabilityType capabilityType, @NotNull RequirementAware requirementAware) {
        this.capabilityDecorators.add(new RequirementDecorator(requirement, capabilityType, this.textProvider, this, requirementAware));
    }

    public int hashCode() {
        return new HashCodeBuilder(859, 5).append(this.capabilityType.getSortOrder()).append((Object)this.getTypeKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CapabilityGroup)) {
            return false;
        }
        CapabilityGroup rhs = (CapabilityGroup)o;
        return new EqualsBuilder().append(this.capabilityType.getSortOrder(), rhs.capabilityType.getSortOrder()).append((Object)this.getTypeKey(), (Object)rhs.getTypeKey()).isEquals();
    }

    @Override
    public int compareTo(CapabilityGroup o) {
        return new CompareToBuilder().append(this.capabilityType.getSortOrder(), o.capabilityType.getSortOrder()).append((Object)this.getTypeKey(), (Object)o.getTypeKey()).toComparison();
    }
}

