/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.AbstractDecoratedCapabilityRequirement;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilityType;
import com.opensymphony.xwork2.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityDecorator
extends AbstractDecoratedCapabilityRequirement {
    private String overrideValue;
    private CapabilitySet capabilitySet;
    private CapabilitySource capabilitySource;

    public CapabilityDecorator(@NotNull Capability capability, @NotNull CapabilityType capabilityType, @Nullable ReadOnlyCapabilitySet parentCapabilitySet, @NotNull TextProvider textProvider, @NotNull CapabilityGroup capabilityGroup) {
        this(capability.getKey(), capability.getValue(), capability.getCapabilitySource(), capability.getId(), capabilityType, parentCapabilitySet, textProvider, capabilityGroup, capability.getCapabilitySet());
    }

    public CapabilityDecorator(@NotNull String key, @Nullable String value, @Nullable CapabilitySource capabilitySource, long id, @NotNull CapabilityType capabilityType, @Nullable ReadOnlyCapabilitySet parentCapabilitySet, @NotNull TextProvider textProvider, @NotNull CapabilityGroup capabilityGroup, @Nullable CapabilitySet capabilitySet) {
        super(textProvider, capabilityType, key, value, capabilityGroup, id, capabilityType instanceof ReadOnlyCapabilityType);
        this.capabilitySet = capabilitySet;
        if (parentCapabilitySet != null) {
            Capability parentCapability = parentCapabilitySet.getCapability(key);
            this.overrideValue = parentCapability != null ? parentCapability.getValue() : null;
        }
        this.capabilitySource = capabilitySource;
    }

    public CapabilitySet getCapabilitySet() {
        return this.capabilitySet;
    }

    public String getOverriddenValue() {
        return this.overrideValue;
    }

    @Nullable
    public CapabilitySource getCapabilitySource() {
        return this.capabilitySource;
    }

    @NotNull
    public String getCapabilitySourceDescription() {
        if (this.capabilitySource == null) {
            return this.textProvider.getText("agent.capability.source.unknown");
        }
        switch (this.capabilitySource) {
            case UI: {
                return this.textProvider.getText("agent.capability.source.ui");
            }
            case PROPERTIES_FILE: {
                return this.textProvider.getText("agent.capability.source.file");
            }
            case AUTO_DETECTION: {
                return this.textProvider.getText("agent.capability.source.autodetection");
            }
            case SHARED: {
                return this.textProvider.getText("agent.capability.source.shared");
            }
        }
        return this.textProvider.getText("agent.capability.source.unknown");
    }
}

