/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.task.TaskExecutableType;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.BuilderCapabilityDescriptor;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderCapabilityType
extends AbstractCapabilityType {
    private static final Logger log = Logger.getLogger(BuilderCapabilityType.class);
    private static final String FIELD_BUILDER_TYPE = "builderType";
    private static final String FIELD_BUILDER_LABEL = "builderLabel";
    private static final String FIELD_BUILDER_PATH = "builderPath";
    private Supplier<TaskManager> taskManager = ComponentAccessor.TASK_MANAGER;
    private Supplier<TextProvider> textProvider = ComponentAccessor.TEXT_PROVIDER;

    public int getSortOrder() {
        return 100;
    }

    @NotNull
    public String getCapabilityTypeKey() {
        return "builder";
    }

    @NotNull
    public String getCapabilityTypeLabel() {
        return "Executable";
    }

    @Nullable
    public String getViewTypeAction() {
        return "viewBuilders";
    }

    @NotNull
    public String getLabel(@NotNull String key) {
        String[] strings = key.split("\\.", 4);
        if (strings.length == 4) {
            return strings[3];
        }
        log.warn((Object)("Key: '" + key + "' cannot be parsed. Returning full key"));
        return key;
    }

    @Nullable
    public String getExtraInfo(@NotNull String key) {
        String type = this.getTypeFromKey(key);
        if (type != null) {
            BuilderCapabilityDescriptor builderCapabilityDescriptor = this.getBuilderByShortKey(type);
            if (builderCapabilityDescriptor != null) {
                return builderCapabilityDescriptor.getName();
            }
            return type;
        }
        log.warn((Object)("Key: '" + key + "' cannot be parsed. Returning null"));
        return null;
    }

    @Nullable
    private String getTypeFromKey(@NotNull String key) {
        String[] strings = key.split("\\.", 4);
        if (strings.length == 4) {
            return strings[2];
        }
        return null;
    }

    @Nullable
    public String getValueDescriptionKey(@NotNull String key, @Nullable String value) {
        String type = this.getTypeFromKey(key);
        if (type != null) {
            return "agent.capability.type.builder.path.help." + type;
        }
        log.warn((Object)("Key: '" + key + "' cannot be parsed. Returning null"));
        return null;
    }

    public boolean isAllowRename() {
        return true;
    }

    @NotNull
    public String getNewKeyFromLabel(@NotNull String oldKey, @NotNull String label) {
        String type = this.getTypeFromKey(oldKey);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"%s could not be parsed", (Object)oldKey);
        return "system.builder." + type + "." + label;
    }

    public void updatePlanForNewLabel(@NotNull Buildable plan, @NotNull String oldLabel, @NotNull String newLabel) {
        this.updateTasksForNewLabel(plan, "label", oldLabel, newLabel);
    }

    public String getCapabilityTypeSpecificTaskConfigurationKey() {
        return "label";
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String builderType = params.get(FIELD_BUILDER_TYPE)[0];
        String builderLabel = params.get(FIELD_BUILDER_LABEL)[0];
        String builderPath = params.get(FIELD_BUILDER_PATH)[0];
        if (StringUtils.isBlank((CharSequence)builderType)) {
            fieldErrors.put(FIELD_BUILDER_TYPE, "You must select a builder type.");
        } else {
            BambooFieldValidate.checkFieldXssSafety(fieldErrors, (TextProvider)((TextProvider)this.textProvider.get()), (String)FIELD_BUILDER_TYPE, (String)builderType);
        }
        BambooFieldValidate.checkFieldXssSafety(fieldErrors, (TextProvider)((TextProvider)this.textProvider.get()), (String)FIELD_BUILDER_LABEL, (String)builderLabel);
        BuilderCapabilityDescriptor executableDescriptor = this.getBuilderByShortKey(builderType);
        if (executableDescriptor != null) {
            if (StringUtils.isBlank((CharSequence)builderLabel)) {
                fieldErrors.put(FIELD_BUILDER_LABEL, "You must specify a builder label.");
            }
            if (StringUtils.isBlank((CharSequence)builderPath)) {
                fieldErrors.put(FIELD_BUILDER_PATH, "You must specify a path to your builder.");
            }
        }
        return fieldErrors;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String builderType = params.get(FIELD_BUILDER_TYPE)[0];
        String builderLabel = params.get(FIELD_BUILDER_LABEL)[0].trim();
        String builderPath = BambooFilenameUtils.stripTrailingSlashes((String)params.get(FIELD_BUILDER_PATH)[0].trim());
        return new CapabilityImpl("system.builder." + builderType + "." + builderLabel, builderPath, CapabilitySource.UI);
    }

    public Collection<BuilderCapabilityDescriptor> getBuilderTypes() {
        ArrayList<BuilderCapabilityDescriptor> descriptors = new ArrayList<BuilderCapabilityDescriptor>();
        Collection<TaskModuleDescriptor> executableTaskModuleDescriptors = this.getTasksProvidingExecutableConfiguration();
        for (TaskModuleDescriptor taskModuleDescriptor : executableTaskModuleDescriptors) {
            taskModuleDescriptor.getTaskExecutables().stream().filter(TaskExecutableType::isPrimaryCapabilityProvider).forEach(te -> descriptors.add(this.getBuilderCapabilityDescriptor(taskModuleDescriptor, (TaskExecutableType)te)));
        }
        return descriptors;
    }

    private Collection<TaskModuleDescriptor> getTasksProvidingExecutableConfiguration() {
        return Collections2.filter((Collection)((TaskManager)this.taskManager.get()).getAvailableTaskDescriptors(), (Predicate)TaskPredicates.providesExecutableConfiguration());
    }

    private BuilderCapabilityDescriptorImpl getBuilderCapabilityDescriptor(TaskModuleDescriptor taskModuleDescriptor, TaskExecutableType taskExecutable) {
        return new BuilderCapabilityDescriptorImpl(taskModuleDescriptor, taskExecutable, (TextProvider)this.textProvider.get());
    }

    @Nullable
    private BuilderCapabilityDescriptor getBuilderByShortKey(@NotNull String shortKey) {
        Collection<TaskModuleDescriptor> tasksProvidingExecutableConfiguration = this.getTasksProvidingExecutableConfiguration();
        for (TaskModuleDescriptor taskModuleDescriptor : tasksProvidingExecutableConfiguration) {
            Optional<TaskExecutableType> taskExecutable = taskModuleDescriptor.getTaskExecutables().stream().filter(TaskExecutableType::isPrimaryCapabilityProvider).filter(te -> te.getExecutableKey().equals(shortKey)).findFirst();
            if (!taskExecutable.isPresent()) continue;
            return this.getBuilderCapabilityDescriptor(taskModuleDescriptor, taskExecutable.get());
        }
        return null;
    }

    @Deprecated
    public TaskManager getTaskManager() {
        return (TaskManager)this.taskManager.get();
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = ComponentAccessor.wrappedReference((Object)taskManager);
    }

    @Deprecated
    public TextProvider getTextProvider() {
        return (TextProvider)this.textProvider.get();
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = ComponentAccessor.wrappedReference((Object)textProvider);
    }

    private static final class BuilderCapabilityDescriptorImpl
    implements BuilderCapabilityDescriptor {
        private final String name;
        private final String pathHelp;
        private final String executableKey;

        private BuilderCapabilityDescriptorImpl(TaskModuleDescriptor taskModuleDescriptor, TaskExecutableType taskExecutable, TextProvider textProvider) {
            Preconditions.checkNotNull((Object)taskModuleDescriptor, (Object)"taskModuleDescriptor");
            Preconditions.checkNotNull((Object)taskExecutable, (Object)"builderTaskExecutableSupport");
            String executableNameKey = taskExecutable.getI18nExecutableNameKey();
            this.name = StringUtils.isNotBlank((CharSequence)executableNameKey) ? textProvider.getText(executableNameKey, executableNameKey) : (StringUtils.isNotEmpty((CharSequence)taskModuleDescriptor.getName()) ? taskModuleDescriptor.getName() : taskModuleDescriptor.getKey());
            String pathHelpKey = taskExecutable.getI18nPathHelpKey();
            this.pathHelp = StringUtils.isNotEmpty((CharSequence)pathHelpKey) ? textProvider.getText(pathHelpKey) : textProvider.getText("agent.capability.type.builder.value.description");
            this.executableKey = taskExecutable.getExecutableKey();
        }

        @NotNull
        public String getKey() {
            return this.executableKey;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getPathHelp() {
            return this.pathHelp;
        }
    }
}

