/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.DecoratedCapabilityRequirement;
import com.opensymphony.xwork2.TextProvider;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AbstractDecoratedCapabilityRequirement
implements DecoratedCapabilityRequirement {
    private static final Logger log = Logger.getLogger(AbstractDecoratedCapabilityRequirement.class);
    protected final CapabilityType capabilityType;
    protected final CapabilityGroup capabilityGroup;
    private final boolean isReadOnly;
    protected final TextProvider textProvider;
    protected final String key;
    protected final String value;
    protected final Long id;

    public AbstractDecoratedCapabilityRequirement(TextProvider textProvider, CapabilityType capabilityType, String key, String value, CapabilityGroup capabilityGroup, Long id, boolean readonly) {
        this.key = key;
        this.value = value;
        this.textProvider = textProvider;
        this.capabilityType = capabilityType;
        this.capabilityGroup = capabilityGroup;
        this.id = id;
        this.isReadOnly = readonly;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getLabel() {
        return this.capabilityType.getLabel(this.key);
    }

    @Override
    @Nullable
    public String getExtraInfo() {
        return this.capabilityType.getExtraInfo(this.key);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CapabilityGroup getCapabilityGroup() {
        return this.capabilityGroup;
    }

    @Override
    @Nullable
    public String getValueDescription() {
        if (this.capabilityType.getValueDescriptionKey(this.key, this.value) != null) {
            return this.textProvider.getText(this.capabilityType.getValueDescriptionKey(this.key, this.value));
        }
        return null;
    }

    public boolean isReadonly() {
        return this.isReadOnly;
    }

    public int hashCode() {
        return new HashCodeBuilder(337, 3).append((Object)this.getLabel()).append((Object)this.getValue()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecoratedCapabilityRequirement)) {
            return false;
        }
        DecoratedCapabilityRequirement rhs = (DecoratedCapabilityRequirement)o;
        return new EqualsBuilder().append((Object)this.getLabel(), (Object)rhs.getLabel()).append((Object)this.getValue(), (Object)rhs.getValue()).isEquals();
    }

    @Override
    public int compareTo(DecoratedCapabilityRequirement o) {
        return new CompareToBuilder().append((Object)this.getLabel(), (Object)o.getLabel()).append((Object)this.getValue(), (Object)o.getValue()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append((Object)this.getLabel()).append((Object)this.getValue()).toString();
    }
}

