/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Comparator;

public class AgentComparator
implements Comparator<BuildAgent> {
    @Override
    public int compare(BuildAgent first, BuildAgent second) {
        int nameComparisonResult;
        String secondName;
        long secondHash;
        long firstHash = this.calculateHash(first);
        int statusComparisonResult = Long.compare(firstHash, secondHash = this.calculateHash(second));
        if (statusComparisonResult != 0) {
            return statusComparisonResult;
        }
        String firstName = this.getName(first);
        if (firstName != (secondName = this.getName(second))) {
            if (firstName == null) {
                return 1;
            }
            if (secondName == null) {
                return -1;
            }
        }
        if (firstName != null && (nameComparisonResult = firstName.toLowerCase().compareTo(secondName.toLowerCase())) != 0) {
            return nameComparisonResult;
        }
        long firstId = first == null ? Integer.MAX_VALUE : first.getId();
        long secondId = second == null ? Integer.MAX_VALUE : second.getId();
        return Long.compare(firstId, secondId);
    }

    private String getName(BuildAgent agent) {
        String name = null;
        if (agent != null) {
            name = agent.getName();
        }
        return name;
    }

    private long calculateHash(BuildAgent agent) {
        short result = 0;
        if (agent == null || !agent.isActive()) {
            result = (short)(result | 1);
        }
        if (agent == null || !agent.isEnabled()) {
            result = (short)(result | 2);
        }
        return result;
    }
}

