/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.opensymphony.xwork2.ActionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionParamsUtils {
    private static final Logger log = Logger.getLogger(ActionParamsUtils.class);

    private ActionParamsUtils() {
    }

    @Nullable
    public static String getParameter(String parameterName) {
        ActionContext actionContext = ServletActionContext.getContext();
        return ActionParamsUtils.getParameter(actionContext, parameterName);
    }

    @Nullable
    public static String getParameter(ActionContext actionContext, String parameterName) {
        if (actionContext == null) {
            return null;
        }
        HttpParameters parameters = actionContext.getParameters();
        if (parameters == null) {
            return null;
        }
        Parameter parameter = parameters.get((Object)parameterName);
        Object o = parameter.getObject();
        if (o == null && ServletActionContext.getRequest() != null) {
            return ServletActionContext.getRequest().getParameter(parameterName);
        }
        return ActionParamsUtils.getStringFromObject(o);
    }

    @Nullable
    public static String getStringFromObject(@Nullable Object o) {
        if (o instanceof String[]) {
            String[] strings = (String[])o;
            if (strings.length > 0) {
                return strings[0];
            }
            return null;
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public static boolean hasParameter(String parameterName) {
        return StringUtils.isNotEmpty((CharSequence)ActionParamsUtils.getParameter(parameterName));
    }

    @Nullable
    public static String[] toStringArray(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return null;
    }

    private static Map<String, String[]> toStringArrayMap(Map<String, Object> anyParameters) {
        HashMap<String, String[]> stringParameters = new HashMap<String, String[]>();
        for (Map.Entry<String, Object> stringObjectEntry : anyParameters.entrySet()) {
            String[] strings = ActionParamsUtils.toStringArray(stringObjectEntry.getValue());
            if (strings == null) continue;
            stringParameters.put(stringObjectEntry.getKey(), strings);
        }
        return stringParameters;
    }

    @NotNull
    public static Map<String, String[]> getStringArrayMap() {
        HttpParameters parameters = ActionContext.getContext().getParameters();
        HashMap<String, String[]> result = new HashMap<String, String[]>(parameters.size());
        for (Map.Entry entry : parameters.entrySet()) {
            result.put((String)entry.getKey(), ((Parameter)entry.getValue()).getMultipleValues());
        }
        return result;
    }
}

