/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.authentication;

import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Supplier;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class BambooElevatedSecurityGuard
implements ElevatedSecurityGuard {
    private static final Logger log = Logger.getLogger(BambooElevatedSecurityGuard.class);
    private static final String ELEVATED_SECURITY_CHECK_REQUIRED = BambooElevatedSecurityGuard.class.getName() + ".elevatedSecurityCheckRequired";
    private static final String ELEVATED_SECURITY_CHECK_FAILED = BambooElevatedSecurityGuard.class.getName() + ".elevatedSecurityCheckFailed";
    private static final String AUTH_ATTEMPT_COUNTER_UPDATE_FAILED = BambooElevatedSecurityGuard.class.getName() + ".authAttemptCounterUpdateFailed";
    private static final String CAPTCHA_PARAM = "captcha";
    private static final Supplier<ImageCaptchaService> IMAGE_CAPTCHA_SERVICE = ComponentAccessor.newLazyComponentReference((String)"imageCaptchaService");

    public boolean performElevatedSecurityCheck(HttpServletRequest httpServletRequest, String userName) {
        Optional<LoginInformationManager> informationManager = this.getLoginInformationManager();
        if (!informationManager.isPresent()) {
            log.info((Object)"Login information manager not present");
            return false;
        }
        boolean captchaRequired = informationManager.get().isElevatedSecurityCheckRequired(userName);
        if (!captchaRequired) {
            httpServletRequest.removeAttribute(ELEVATED_SECURITY_CHECK_REQUIRED);
            return true;
        }
        httpServletRequest.setAttribute(ELEVATED_SECURITY_CHECK_REQUIRED, (Object)Boolean.TRUE);
        String enteredCaptcha = httpServletRequest.getParameter(CAPTCHA_PARAM);
        if (enteredCaptcha == null) {
            log.info((Object)("CAPTCHA failure for " + userName + " : no CAPTCHA response in request"));
            return BambooElevatedSecurityGuard.captchaFailure(httpServletRequest);
        }
        String atlToken = httpServletRequest.getParameter("atl_token");
        if (atlToken == null) {
            log.warn((Object)("CAPTCHA failure for " + userName + " : no atlToken for CAPTCHA"));
            return BambooElevatedSecurityGuard.captchaFailure(httpServletRequest);
        }
        if (!this.isCaptchaResponseValid(atlToken, enteredCaptcha)) {
            return BambooElevatedSecurityGuard.captchaFailure(httpServletRequest);
        }
        httpServletRequest.removeAttribute(ELEVATED_SECURITY_CHECK_FAILED);
        return true;
    }

    private boolean isCaptchaResponseValid(String atlToken, String enteredCaptcha) {
        try {
            return Boolean.TRUE.equals(((ImageCaptchaService)IMAGE_CAPTCHA_SERVICE.get()).validateResponseForID(atlToken, (Object)enteredCaptcha));
        }
        catch (CaptchaServiceException e) {
            log.warn((Object)"Error while validating CAPTCHA response", (Throwable)e);
            return false;
        }
    }

    private static boolean captchaFailure(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute(ELEVATED_SECURITY_CHECK_FAILED, (Object)Boolean.TRUE);
        return false;
    }

    public void onFailedLoginAttempt(HttpServletRequest httpServletRequest, String userName) {
        log.trace((Object)("Failed login attempt, userName=" + userName + ", IP=" + httpServletRequest.getRemoteAddr()));
        AtomicBoolean renderCaptcha = new AtomicBoolean();
        try {
            this.getLoginInformationManager().ifPresent(manager -> renderCaptcha.set(manager.incrementFailedCountAndCheckThreshold(userName)));
        }
        catch (IllegalArgumentException e) {
            httpServletRequest.setAttribute(AUTH_ATTEMPT_COUNTER_UPDATE_FAILED, (Object)Boolean.TRUE);
            return;
        }
        if (renderCaptcha.get()) {
            httpServletRequest.setAttribute(ELEVATED_SECURITY_CHECK_REQUIRED, (Object)Boolean.TRUE);
        }
    }

    public void onSuccessfulLoginAttempt(HttpServletRequest httpServletRequest, String userName) {
        httpServletRequest.removeAttribute(ELEVATED_SECURITY_CHECK_REQUIRED);
        try {
            this.getLoginInformationManager().ifPresent(manager -> manager.resetFailedLoginAttemptsCount(userName));
        }
        catch (Exception e) {
            httpServletRequest.setAttribute(AUTH_ATTEMPT_COUNTER_UPDATE_FAILED, (Object)Boolean.TRUE);
        }
    }

    public void init(Map<String, String> params, SecurityConfig config) {
    }

    public static boolean isElevatedSecurityRequired(ServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(ELEVATED_SECURITY_CHECK_REQUIRED));
    }

    public static boolean isElevatedSecurityFailed(ServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(ELEVATED_SECURITY_CHECK_FAILED));
    }

    private Optional<LoginInformationManager> getLoginInformationManager() {
        if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable((LoginInformationManager)ContainerManager.getComponent((String)"loginInformationManager"));
        }
        catch (Exception e) {
            log.warn((Object)"Authentication attempt with invalid context", (Throwable)e);
            return Optional.empty();
        }
    }

    public static boolean isAuthCounterUpdateFailed(ServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(AUTH_ATTEMPT_COUNTER_UPDATE_FAILED));
    }
}

