/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.authentication;

import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.crowd.exception.runtime.CommunicationException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Stopwatch;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BambooAuthenticator
extends DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(BambooAuthenticator.class);

    public boolean login(HttpServletRequest request, HttpServletResponse response, @Nullable String username, String password, boolean cookie) throws AuthenticatorException {
        if (username == null || !ContainerManager.isContainerSetup()) {
            return false;
        }
        Stopwatch started = Stopwatch.createStarted();
        try {
            boolean bl = super.login(request, response, username, password, cookie);
            return bl;
        }
        catch (CommunicationException e) {
            log.error((Object)"User repository communication failed: ", (Throwable)e);
            throw new AuthenticatorException("User repository communication failed");
        }
        catch (CrowdRuntimeException e) {
            log.error((Object)"Authentication failed due to embedded crowd error: ", (Throwable)e);
            throw new AuthenticatorException("Authentication failed due to embedded crowd error");
        }
        finally {
            log.info((Object)("Finished doing authentication checks for " + username + ", took " + started));
        }
    }

    protected boolean authenticate(Principal user, String password) {
        BambooUserManager bambooUserManager = (BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get();
        return bambooUserManager.authenticate(user.getName(), password);
    }

    protected Principal getUser(String uid) {
        return ((BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get()).getUser(uid);
    }
}

