/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.user.User;
import java.security.Principal;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DefaultAuthenticationContext
implements BambooAuthenticationContext {
    private static final Logger log = Logger.getLogger(DefaultAuthenticationContext.class);
    @Inject
    private BambooUserManager bambooUserManager;
    private final I18nBeanFactory i18nBeanFactory;

    public DefaultAuthenticationContext(I18nBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Deprecated
    public DefaultAuthenticationContext(BambooUserManager bambooUserManager, I18nBeanFactory i18nBeanFactory) {
        this.bambooUserManager = bambooUserManager;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Nullable
    public User getUser() {
        String currentUserName = this.getUserName();
        if (currentUserName != null) {
            return this.bambooUserManager.getUser(currentUserName);
        }
        return null;
    }

    @Nullable
    public String getUserName() {
        Principal user;
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance(null);
        HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        if (request != null && (user = securityConfig.getAuthenticator().getUser(request)) != null) {
            return user.getName();
        }
        return this.getUserNameFromSecurityContext();
    }

    @Nullable
    public String getUserNameFromSecurityContext() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication != null) {
            return authentication.getName();
        }
        return null;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public I18nBean getI18NBean() {
        return this.i18nBeanFactory.getI18nBean(this.getLocale());
    }
}

