/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.persistence.BambooConnectionCallback;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class ThereIsSingleRowInHibernateUniqueKeyTable
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(ThereIsSingleRowInHibernateUniqueKeyTable.class);
    private static final String SQL_COUNT_AND_GET_MAX = "select count(next_hi) from hibernate_unique_key";

    public ThereIsSingleRowInHibernateUniqueKeyTable() {
        super("4300", "Make sure there's single row in HIBERNATE_UNIQUE_KEY table");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(new BambooConnectionCallback(){

            public void doInHibernateTransaction(@NotNull Connection connection) throws HibernateException, SQLException {
                int countNextHi;
                try (Statement countStmt = connection.createStatement();
                     ResultSet rs = countStmt.executeQuery(ThereIsSingleRowInHibernateUniqueKeyTable.SQL_COUNT_AND_GET_MAX);){
                    rs.next();
                    countNextHi = rs.getInt(1);
                }
                if (countNextHi > 1) {
                    ThereIsSingleRowInHibernateUniqueKeyTable.this.errors.add(String.format("%s: multiple entries in the HIBERNATE_UNIQUE_KEY table", ((Object)((Object)ThereIsSingleRowInHibernateUniqueKeyTable.this)).getClass().getName()));
                }
            }
        });
    }
}

