/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class TableNamesAreCaseInsensitive
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(TableNamesAreCaseInsensitive.class);
    @Autowired
    private DbmsBean dbmsBean;

    public TableNamesAreCaseInsensitive() {
        super("51302", "Check that MySQL tables are case insensitive");
    }

    public void doUpgrade() throws Exception {
        if (this.dbmsBean.isMsSqlServer()) {
            return;
        }
        this.withDatabaseConnection(this::checkThatTablesAreCaseInsensitive);
    }

    private void checkThatTablesAreCaseInsensitive(Connection c) throws SQLException {
        boolean lowerCaseExists = TableNamesAreCaseInsensitive.isTablePresent(c, "bandana");
        boolean upperCaseExists = TableNamesAreCaseInsensitive.isTablePresent(c, "BANDANA");
        if (!lowerCaseExists || !upperCaseExists) {
            log.warn((Object)"This database seems to use case-sensitive table names. Bamboo recommends setting lower_case_table_names variable to 1. Please consult documentation (https://confluence.atlassian.com/display/BAMBOO/MySQL) for more details.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTablePresent(@NotNull Connection connection, @NotNull String tableName) {
        try (Statement statement = connection.createStatement();){
            statement.execute("select count(*) from " + tableName);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ignored) {
            TableNamesAreCaseInsensitive.rollbackQuietly(connection);
            return false;
        }
    }

    private static void rollbackQuietly(@NotNull Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException e) {
            log.warn((Object)"", (Throwable)e);
        }
    }
}

