/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.persistence.BambooConnectionCallback;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlanKeysCorrectlyFormatted
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(PlanKeysCorrectlyFormatted.class);

    public PlanKeysCorrectlyFormatted() {
        super("2902", "Test if plan keys are correctly formatted");
    }

    public void doUpgrade() throws Exception {
        this.withDatabaseConnection(new BambooConnectionCallback(){

            public void doInHibernateTransaction(@NotNull Connection connection) throws SQLException {
                block31: {
                    try (Statement statement = connection.createStatement();){
                        ResultSet resultSet = statement.executeQuery("select BUILD_TYPE, FULL_KEY from BUILD");
                        Throwable throwable = null;
                        block20: while (true) {
                            try {
                                while (resultSet.next()) {
                                    String planType = resultSet.getString(1);
                                    String fullKey = resultSet.getString(2);
                                    try {
                                        PlanKey planKey = PlanKeys.getPlanKey((String)fullKey);
                                        if (PlanType.CHAIN.name().equals(planType)) {
                                            if (!PlanKeys.isJobKey((PlanKey)planKey)) continue block20;
                                            PlanKeysCorrectlyFormatted.this.errors.add(String.format("%s: incorrect CHAIN key '%s'", this.getClass().getName(), fullKey));
                                            continue block20;
                                        }
                                        if (PlanType.CHAIN_BRANCH.name().equals(planType)) {
                                            if (!PlanKeys.isJobKey((PlanKey)planKey)) continue block20;
                                            PlanKeysCorrectlyFormatted.this.errors.add(String.format("%s: incorrect CHAIN_BRANCH key '%s'", this.getClass().getName(), fullKey));
                                            continue block20;
                                        }
                                        if (PlanType.JOB.name().equals(planType)) {
                                            if (PlanKeys.isJobKey((PlanKey)planKey)) continue block20;
                                            PlanKeysCorrectlyFormatted.this.errors.add(String.format("%s: incorrect JOB key '%s'", this.getClass().getName(), fullKey));
                                            continue block20;
                                        }
                                        PlanKeysCorrectlyFormatted.this.errors.add(String.format("%s: plan '%s' is of unknown type '%s'", this.getClass().getName(), fullKey, planType));
                                        continue block20;
                                    }
                                    catch (IllegalArgumentException e) {
                                        PlanKeysCorrectlyFormatted.this.errors.add(String.format("%s: incorrect plan key '%s'", this.getClass().getName(), fullKey));
                                    }
                                }
                                break block31;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                        }
                    }
                }
            }
        });
    }
}

