/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MsSqlConfigurationValid
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(MsSqlConfigurationValid.class);
    private static final String SELECT_DB_PROPERTIES = "SELECT collation_name, is_read_committed_snapshot_on FROM sys.databases WHERE name = '%s'";
    private static final String FIND_WRONG_COLLATION = "SELECT object_id, name, collation_name FROM sys.columns WHERE collation_name NOT LIKE '%_CS_AS%' AND collation_name NOT LIKE '%_BIN%' AND object_id IN (SELECT object_id FROM sys.objects WHERE type = 'U')";
    @Autowired
    private DbmsBean dbmsBean;

    public MsSqlConfigurationValid() {
        super("51301", "Test if collation and commit isolation is set correctly");
    }

    public void doUpgrade() throws Exception {
        if (SystemProperty.SKIP_MSSQL_CONFIG_VALIDATION.getTypedValue() || !this.dbmsBean.isMsSqlServer()) {
            return;
        }
        this.withDatabaseConnection(connection -> {
            block52: {
                try (Statement stmt = connection.createStatement();
                     ResultSet dbNameSelect = stmt.executeQuery("SELECT DB_NAME()");){
                    dbNameSelect.next();
                    String dbName = dbNameSelect.getString(1);
                    try (ResultSet rs = stmt.executeQuery(String.format(SELECT_DB_PROPERTIES, dbName));){
                        rs.next();
                        String collationName = rs.getString(1);
                        Integer readCommittedOn = rs.getInt(2);
                        if (readCommittedOn == 0) {
                            this.errors.add("Bamboo DB must use READ COMMITTED SNAPSHOT isolation level. Refer to: https://confluence.atlassian.com/display/BAMBOO/Microsoft+SQL+Server");
                        }
                        if (!collationName.contains("_CS_AS") && !collationName.contains("_BIN")) {
                            this.errors.add("Bamboo DB must use case and accent sensitive (*_CS_AS) or binary (*_BIN) collation. Current value: " + collationName + "Refer to: https://confluence.atlassian.com/display/KB/How+to+fix+the+collation+of+a+Microsoft+SQL+Server+database for further instructions.");
                        }
                    }
                    if (!this.errors.isEmpty()) break block52;
                    rs = stmt.executeQuery(FIND_WRONG_COLLATION);
                    var8_12 = null;
                    try {
                        if (rs.next()) {
                            this.errors.add("Bamboo DB must use case and accent sensitive (*_CS_AS) or binary (*_BIN) collation on all tables and columns. Refer to: https://confluence.atlassian.com/display/KB/How+to+fix+the+collation+of+a+Microsoft+SQL+Server+database for further instructions.");
                        }
                    }
                    catch (Throwable throwable) {
                        var8_12 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var8_12 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var8_12.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
            }
        });
        if (!this.errors.isEmpty()) {
            log.info((Object)("Add -D" + SystemProperty.SKIP_MSSQL_CONFIG_VALIDATION.getKey() + "=true parameter to bamboo command line in order to skip this check"));
        }
    }
}

