/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.XpathXmlUpgrader;
import com.atlassian.config.ApplicationConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public class MailServerJndiLocationIsValid
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(MailServerJndiLocationIsValid.class);
    @Inject
    private ApplicationConfiguration applicationConfiguration;
    private File mailConfigFile;

    public MailServerJndiLocationIsValid() {
        super("60001", "Make sure JNDI location of mail server is valid");
    }

    public void doUpgrade() throws Exception {
        File file = this.getBambooMailConfigFile();
        if (file.isFile()) {
            log.info((Object)String.format("Validating JNDI location of mail server in configuration file '%s'.", file.getAbsolutePath()));
            XpathXmlUpgrader.visit((File)file, (String)"/mail-servers/smtp-server/jndi-location", this::validateJndiLocation);
        } else {
            log.info((Object)String.format("Mail server configuration file '%s' was not found. Skipping validation task.", file.getAbsolutePath()));
        }
    }

    @NotNull
    @VisibleForTesting
    File getBambooMailConfigFile() {
        if (this.mailConfigFile == null) {
            this.mailConfigFile = new File(this.applicationConfiguration.getApplicationHome(), "bamboo-mail.cfg.xml");
        }
        return this.mailConfigFile;
    }

    private void validateJndiLocation(@NotNull Node node) {
        Optional.ofNullable(node.getTextContent()).filter(StringUtils::isNotEmpty).map(String::trim).filter(jndiLocation -> !jndiLocation.startsWith("java:")).ifPresent(this::registerInvalidJndiLocation);
    }

    private void registerInvalidJndiLocation(@NotNull String jndiLocation) {
        String errorMessage = String.format("Mail server in configuration file '%s' contains invalid JNDI location. The value must be prefixed with 'java:', but was '%s'.", this.getBambooMailConfigFile().getAbsolutePath(), jndiLocation);
        this.errors.add(errorMessage);
        log.error((Object)errorMessage);
    }
}

