/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.config.ApplicationConfiguration;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import org.springframework.util.ClassUtils;

public class JdbcDriverAvailableInClasspath
extends AbstractBootstrapUpgradeTask {
    @Inject
    private ApplicationConfiguration applicationConfiguration;
    @Inject
    private TextProvider textProvider;

    public JdbcDriverAvailableInClasspath() {
        super("2", "Validate that JDBC driver is available in classpath");
    }

    public void doUpgrade() throws Exception {
        String jdbcDriverClass;
        String datasourceName = (String)this.applicationConfiguration.getProperty((Object)"hibernate.connection.datasource");
        if (datasourceName == null && !ClassUtils.isPresent((String)(jdbcDriverClass = (String)this.applicationConfiguration.getProperty((Object)"hibernate.connection.driver_class")), (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            String errorMessageKey = Objects.equals(DatabaseType.MYSQL.getDriverClassName(), jdbcDriverClass) ? "validation.error.jdbc.driver.not.available.in.classpath.mysql" : "validation.error.jdbc.driver.not.available.in.classpath";
            throw new ValidationException(this.textProvider.getText(errorMessageKey, Collections.singletonList(jdbcDriverClass)));
        }
    }
}

