/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Version;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class JavaVersionIsSupported
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(JavaVersionIsSupported.class);
    public static final List<Version> SUPPORTED_VERSIONS = new ImmutableList.Builder().add((Object)new Version(1, 8, 0)).build();

    public JavaVersionIsSupported() {
        super("4", "Verify Java compatibility");
    }

    public void doUpgrade() throws ValidationException {
        if (BuildUtils.isFunctionalTest()) {
            log.info((Object)"Running a functional test, skipping Java version check.");
            return;
        }
        if (!SystemProperty.CHECK_JAVA_VERSION_ON_UPGRADE.getTypedValue()) {
            log.info((Object)String.format("Java version check skipped since the %s flag is set to false.", SystemProperty.CHECK_JAVA_VERSION_ON_UPGRADE.getKey()));
            return;
        }
        String[] versionArray = JavaVersionIsSupported.parseVersionArray(SystemUtils.JAVA_VERSION);
        Version parsedVersion = JavaVersionIsSupported.parseJavaVersion(versionArray);
        log.info((Object)("Testing compatibility of Java version " + SystemUtils.JAVA_VERSION + " with this version of Bamboo."));
        if (!SUPPORTED_VERSIONS.contains(parsedVersion)) {
            String msg = String.format("Bamboo doesn't support Java version %s. Please check https://confluence.atlassian.com/display/BAMBOO/Supported+Platforms for more information. This check can be skipped by setting the %s flag to false.", SystemUtils.JAVA_VERSION, SystemProperty.CHECK_JAVA_VERSION_ON_UPGRADE);
            log.error((Object)msg);
            throw new ValidationException(msg);
        }
        log.info((Object)String.format("Detected Java version %s, your version is supported.", SystemUtils.JAVA_VERSION));
    }

    public static String[] parseVersionArray(String version) {
        String[] temp = version.split("[+_-]")[0].split("\\.");
        Object[] parsedVersion = new String[3];
        Arrays.fill(parsedVersion, "0");
        for (int i = 0; i < temp.length; ++i) {
            if (i >= 3) continue;
            parsedVersion[i] = temp[i];
        }
        return parsedVersion;
    }

    public static Version parseJavaVersion(String[] version) {
        int[] temp = new int[3];
        Arrays.fill(temp, 0);
        for (int i = 0; i < version.length; ++i) {
            temp[i] = Integer.parseInt(version[i]);
        }
        return new Version(temp[0], temp[1], 0);
    }
}

