/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.upgrade.UpgradeException;
import java.io.File;
import org.apache.log4j.Logger;

public class IndexDirectoryPresent
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(IndexDirectoryPresent.class);

    public IndexDirectoryPresent() {
        super("51010", "Check if lucene index root dir exists");
    }

    public void doUpgrade() throws Exception {
        File indexDirectory = this.bootstrapManager.getIndexDirectory();
        if (indexDirectory == null) {
            throw new UpgradeException("bootstrapManager.getIndexDirectory() returned null value. Perhaps lucene.index.dir property is not set?");
        }
        if (!indexDirectory.isDirectory() && !indexDirectory.mkdirs()) {
            throw new UpgradeException(String.format("Unable to create directory %s, please try creating it manually and restart the instance.", indexDirectory));
        }
    }
}

