/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.log4j.Logger;

public class FileNameEncodingIsReasonable
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(FileNameEncodingIsReasonable.class);

    public FileNameEncodingIsReasonable() {
        super("51210", "Verify file name encoding");
    }

    public void doUpgrade() throws Exception {
        Optional<Boolean> encodingReasonable = FileNameEncodingIsReasonable.isEncodingReasonable(this.bootstrapManager.getArtifactsDirectory());
        if (!encodingReasonable.isPresent()) {
            log.warn((Object)"Unable to determine the encoding used to encode file names.");
        } else if (!encodingReasonable.get().booleanValue()) {
            log.warn((Object)("Encoding [" + FileNameEncodingIsReasonable.getFileNameEncoding() + "] used to encode file names is not capable of handling extended character sets. You may encounter failures during artifact transfers."));
        }
    }

    static Optional<Boolean> isEncodingReasonable(String artifactsDirectory) {
        try {
            Path artifactFolder = Paths.get(artifactsDirectory, new String[0]);
            Path testFile = Files.createFile(artifactFolder.resolve(Paths.get("b\u017ad\u017ai\u0105gwa", new String[0])), new FileAttribute[0]);
            boolean exists = Files.exists(artifactFolder.resolve(Paths.get("b\u017ad\u017ai\u0105gwa", new String[0])), new LinkOption[0]);
            Files.delete(testFile);
            return Optional.of(exists);
        }
        catch (Exception e) {
            log.trace(null, (Throwable)e);
            return Optional.of(false);
        }
    }

    static String getFileNameEncoding() {
        return System.getProperty("sun.jnu.encoding");
    }
}

