/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.config.ApplicationConfiguration;
import javax.inject.Inject;

public class DoNotStartWithHsqldb
extends AbstractUpgradeTask {
    @Inject
    private ApplicationConfiguration applicationConfiguration;

    public DoNotStartWithHsqldb() {
        super("1", "Assert that Bamboo isn't running on HSQL database");
    }

    public void doUpgrade() throws Exception {
        String dialect = (String)this.applicationConfiguration.getProperty((Object)"hibernate.dialect");
        if (dialect != null && dialect.matches(".*?HSQL.*?Dialect$")) {
            throw new ValidationException("Bamboo doesn't support HSQL database anymore, as it was replaced by H2. Migrate to a supported database before upgrading your Bamboo instance. Learn more: https://confluence.atlassian.com/x/QgU_EQ");
        }
    }
}

