/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.hibernate.DatabaseVersionHolder;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.util.Version;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.upgrade.UpgradeException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseIsSupported
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(DatabaseIsSupported.class);
    private static final Map<DatabaseType, Version> MINIMAL_SUPPORTED_VERSION = ImmutableMap.of((Object)DatabaseType.MSSQL, (Object)new Version(13, 0, 0), (Object)DatabaseType.MYSQL, (Object)new Version(5, 6, 3), (Object)DatabaseType.ORACLE, (Object)new Version(12, 2, 0), (Object)DatabaseType.POSTGRESQL, (Object)new Version(9, 6, 0), (Object)DatabaseType.H2, (Object)new Version(1, 4, 0));
    private static final EnumSet<DatabaseType> DATABASES_WITHOUT_FORKS = EnumSet.of(DatabaseType.MSSQL, DatabaseType.ORACLE, DatabaseType.H2);
    private static final Pattern MYSQL_VERSION_PATTERN = Pattern.compile("\\d+\\.\\d+\\.(\\d+).*");
    @Autowired
    private DbmsBean dbmsBean;

    public DatabaseIsSupported() {
        super("51111", "Verify DB compatibility");
    }

    public void doUpgrade() throws Exception {
        DatabaseMetaData metadata = this.getDatabaseMetadata();
        Version databaseVersion = new Version(metadata.getDatabaseMajorVersion(), metadata.getDatabaseMinorVersion(), this.getMicroPartOfVersion(metadata));
        databaseVersion.setProductName(metadata.getDatabaseProductName());
        databaseVersion.setVersionString(metadata.getDatabaseProductVersion());
        Version driverVersion = new Version(metadata.getDriverMajorVersion(), metadata.getDriverMinorVersion(), 0);
        driverVersion.setProductName(metadata.getDriverName());
        driverVersion.setVersionString(metadata.getDriverVersion());
        log.info((Object)("Testing compatibility of " + databaseVersion + " using JDBC driver " + driverVersion + " with this version of Bamboo."));
        DatabaseVersionHolder.setDatabaseType((DatabaseType)this.dbmsBean.getDatabaseType());
        DatabaseVersionHolder.setVersion((Version)databaseVersion);
        Version minimalSupportedVersion = MINIMAL_SUPPORTED_VERSION.get(this.dbmsBean.getDatabaseType());
        if (minimalSupportedVersion == null) {
            log.error((Object)"Unknown DBMS.");
            return;
        }
        if (minimalSupportedVersion.isGreaterThan(databaseVersion)) {
            log.error((Object)String.format("Detected %s version %s, minimal supported version is %s", this.dbmsBean.getDatabaseType(), databaseVersion, minimalSupportedVersion));
            String msg = String.format("Bamboo doesn't support %s version %s. Please check https://confluence.atlassian.com/display/BAMBOO/Supported+Platforms for more information.", metadata.getDatabaseProductName(), metadata.getDatabaseProductVersion());
            log.error((Object)msg);
            if (this.shouldThrowExceptionOnVersionIncompatibility()) {
                throw new UpgradeException(msg);
            }
        } else {
            log.info((Object)String.format("Detected %s version %s, your DBMS version is supported.", this.dbmsBean.getDatabaseType(), databaseVersion));
        }
    }

    @VisibleForTesting
    boolean shouldThrowExceptionOnVersionIncompatibility() {
        boolean throwException;
        DatabaseType databaseType = this.dbmsBean.getDatabaseType();
        boolean isMysqlDatabase = DatabaseType.MYSQL == databaseType;
        boolean bl = throwException = DATABASES_WITHOUT_FORKS.contains(databaseType) || isMysqlDatabase && SystemProperty.CHECK_MYSQL_VER_ON_UPGRADE.getTypedValue();
        if (throwException && isMysqlDatabase) {
            log.error((Object)String.format("For avoiding failure please set system property %s to true", SystemProperty.CHECK_MYSQL_VER_ON_UPGRADE.getKey()));
        }
        return throwException;
    }

    @VisibleForTesting
    int getMicroPartOfVersion(@NotNull DatabaseMetaData metadata) throws SQLException {
        if (this.dbmsBean.getDatabaseType() != DatabaseType.MYSQL) {
            return 0;
        }
        return DatabaseIsSupported.detectMicroPartOfMySQLDB(metadata);
    }

    private static int detectMicroPartOfMySQLDB(@NotNull DatabaseMetaData metadata) throws SQLException {
        String databaseProductVersion = metadata.getDatabaseProductVersion();
        Matcher matcher = MYSQL_VERSION_PATTERN.matcher(databaseProductVersion);
        if (matcher.matches()) {
            String group = matcher.group(1);
            if (StringUtils.isNumeric((CharSequence)group)) {
                return Integer.parseInt(group);
            }
            log.info((Object)("Can't convert micro part of DB version to number " + group));
        } else {
            log.info((Object)("Can't detect micro part of DB version '" + databaseProductVersion + "'"));
        }
        return 0;
    }

    private DatabaseMetaData getDatabaseMetadata() throws SQLException {
        try (Connection connection = this.getDatabaseConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData;
        }
    }
}

