/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ClearingFelixCache
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(ClearingFelixCache.class);
    @Autowired
    private HomeDirectoryLayout homeDirectoryLayout;

    public ClearingFelixCache() {
        super("51404", "Make sure OSGi bundle cache directory is empty, clean it if needed.");
    }

    public void doUpgrade() throws Exception {
        File pluginCacheDirectory = this.homeDirectoryLayout.getPluginCacheDirectory();
        File osgiBundleCache = new File(pluginCacheDirectory, "felix");
        try {
            this.ensureDirectoryExists(osgiBundleCache);
            FileUtils.cleanDirectory((File)osgiBundleCache);
        }
        catch (IllegalStateException e) {
            String errorMessage = "Couldn't clean OSGi bundle cache directory: " + pluginCacheDirectory;
            this.errors.add(errorMessage);
            log.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void ensureDirectoryExists(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("'" + dir + "' is not a directory");
        }
        if (!dir.exists() && !dir.mkdir()) {
            throw new IllegalArgumentException("Directory '" + dir + "' cannot be created");
        }
    }
}

