/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.UpgradeUtilityBean;
import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.upgrade.utils.impl.BootstrapUpgradeHelper;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.config.ApplicationConfiguration;
import com.opensymphony.xwork2.TextProvider;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BuildNumberInHomeMatchesDatabase
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(BuildNumberInHomeMatchesDatabase.class);
    private static final String BAMBOO_6_2_BUILD_NUMBER = "60202";
    private final Comparator<String> buildNumberComparator = Comparators.getApplicationBuildNumberComparator();
    @Inject
    private ApplicationConfiguration applicationConfiguration;
    @Inject
    private BootstrapUpgradeHelper bootstrapUpgradeHelper;
    @Inject
    private TextProvider textProvider;
    @Inject
    private UpgradeUtilityBean upgradeUtilityBean;

    @Inject
    public BuildNumberInHomeMatchesDatabase() {
        super("3", "Validate if build number in home directory matches database");
    }

    public void doUpgrade() throws Exception {
        if (!this.applicationConfiguration.isSetupComplete()) {
            return;
        }
        String buildNumberFromHomeDirectory = this.getBuildNumberFromHomeDirectory();
        Optional<String> buildNumberFromDatabase = this.getBuildNumberFromDatabase();
        if (buildNumberFromDatabase.isPresent()) {
            if (!Objects.equals(buildNumberFromHomeDirectory, buildNumberFromDatabase.get())) {
                log.fatal((Object)String.format("Bamboo home directory build number [%s] does not match build number from database [%s]", buildNumberFromHomeDirectory, buildNumberFromDatabase.get()));
                throw new ValidationException(this.textProvider.getText("validation.error.bamboo.home.does.not.match.database"));
            }
        } else if (Comparators.isGreaterOrEqual((Object)buildNumberFromHomeDirectory, (Object)BAMBOO_6_2_BUILD_NUMBER, this.buildNumberComparator)) {
            log.fatal((Object)String.format("Bamboo home directory comes from version 6.2 or older (build number [%s]) but database does not contain build number", buildNumberFromHomeDirectory));
            throw new ValidationException(this.textProvider.getText("validation.error.bamboo.home.does.not.match.database"));
        }
    }

    private String getBuildNumberFromHomeDirectory() throws ValidationException {
        String buildNumber = this.bootstrapUpgradeHelper.getBuildNumberFromHomeDirectory();
        if (!StringUtils.isNumeric((CharSequence)buildNumber)) {
            log.fatal((Object)String.format("Unable to parse Bamboo build number [%s]", buildNumber));
            throw new ValidationException(this.textProvider.getText("validation.error.generic"));
        }
        return buildNumber;
    }

    /*
     * Exception decompiling
     */
    private Optional<String> getBuildNumberFromDatabase() throws ValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

