/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.UpgradeUtilityBean;
import com.atlassian.bamboo.upgrade.utils.impl.BootstrapUpgradeHelper;
import com.opensymphony.xwork2.TextProvider;
import java.util.Arrays;

public class BuildNumberApplicableForUpgrade
extends AbstractBootstrapUpgradeTask {
    private BootstrapUpgradeHelper bootstrapUpgradeHelper;
    private TextProvider textProvider;
    private UpgradeUtilityBean upgradeUtilityBean;

    public BuildNumberApplicableForUpgrade() {
        super("2901", "Test if build number is applicable for upgrade");
    }

    public void doUpgrade() throws Exception {
        String bambooBuildNumber = this.bootstrapUpgradeHelper.getBuildNumberFromHomeDirectory();
        if (!this.upgradeUtilityBean.isBuildNumberApplicableForUpgrade(bambooBuildNumber)) {
            this.errors.add(this.textProvider.getText("upgrade.error.tooOldForDirectUpgrade", Arrays.asList(bambooBuildNumber, this.upgradeUtilityBean.getLowestBambooVersionApplicableForUpgrade())));
        }
    }

    public void setBootstrapUpgradeHelper(BootstrapUpgradeHelper bootstrapUpgradeHelper) {
        this.bootstrapUpgradeHelper = bootstrapUpgradeHelper;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setUpgradeUtilityBean(UpgradeUtilityBean upgradeUtilityBean) {
        this.upgradeUtilityBean = upgradeUtilityBean;
    }
}

