/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.tasks.validation;

import com.atlassian.bamboo.persistence.BambooConnectionCallback;
import com.atlassian.bamboo.upgrade.AbstractBootstrapUpgradeTask;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class BranchKeyStartsWithMastersChainKey
extends AbstractBootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(BranchKeyStartsWithMastersChainKey.class);
    private static final String SQL_INVALID_BRANCH_KEYS = "select BRANCH.FULL_KEY from BUILD MASTER join BUILD BRANCH on MASTER.BUILD_ID = BRANCH.MASTER_ID where MASTER.BUILD_TYPE = 'CHAIN' and not BRANCH.FULL_KEY like %s";
    private static final String[] SQL_INVALID_BRANCH_KEYS_CONCAT_PARAM = new String[]{"MASTER.FULL_KEY", "'%'"};
    private DbmsBean dbmsBean;

    public BranchKeyStartsWithMastersChainKey() {
        super("4410", "Make sure that all branch keys start with their master's chain key");
    }

    public void doUpgrade() throws Exception {
        final String invalidBranchKeysSql = String.format(SQL_INVALID_BRANCH_KEYS, this.dbmsBean.getConcat(SQL_INVALID_BRANCH_KEYS_CONCAT_PARAM));
        this.withDatabaseConnection(new BambooConnectionCallback(){

            public void doInHibernateTransaction(@NotNull Connection connection) throws HibernateException, SQLException {
                HashSet<String> invalidBranchKeys = new HashSet<String>();
                try (Statement stmt = connection.createStatement();
                     ResultSet rs = stmt.executeQuery(invalidBranchKeysSql);){
                    while (rs.next()) {
                        invalidBranchKeys.add(rs.getString(1));
                    }
                }
                if (!Iterables.isEmpty(invalidBranchKeys)) {
                    BranchKeyStartsWithMastersChainKey.this.errors.add(String.format("%s: There are invalid branch keys in the BUILD table: %s", ((Object)((Object)BranchKeyStartsWithMastersChainKey.this)).getClass().getName(), Iterables.toString(invalidBranchKeys)));
                }
            }
        });
    }

    public void setDbmsBean(DbmsBean dbmsBean) {
        this.dbmsBean = dbmsBean;
    }
}

